#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef struct node{
	char value[20];
	struct node*left,*right;
} NODE;
typedef NODE*tree;


tree cons(char c[], tree l, tree r)
{
	tree t;
	t=(NODE*)malloc(sizeof(NODE));
	strcpy(t->value,c);
	t->right=r;
	t->left=l;
	return t;
}

tree insord(tree t, char c[])
{
	if (t==NULL)
		return(cons(c,NULL,NULL));
	else
	{
		if(strcmp(c,t->value)<0)
			t->left=insord(t->left,c);
		if(strcmp(c,t->value)>0)
			t->right=insord(t->right,c);
		return t;
	}
}

tree inorder(tree t)
{
	if(t!=NULL)
	{
		inorder(t->left);
		printf("%s\n",t->value);
		inorder(t->right);
	}
}

void funzioneB(tree t, FILE *f)
{
	if(t!=NULL)
	{
		funzioneB(t->left,f);
		fprintf(f,"%s\n",t->value);
		funzioneB(t->right,f);
	}
}

tree funzioneA(tree t, FILE*f1, FILE*f2)
{
	char testo1[20];
	char testo2[20];
	
	while(!feof(f1))
	{
		fscanf(f1,"%s",testo1);
		while(!feof(f2))
		{
			fscanf(f2,"%s",testo2);
			if(strcmp(testo1,testo2)==0)
			{
				t=insord(t,testo1);
			}
		}
		rewind(f2);
	}
	return t;
}

main()
{
	FILE *f1;
	FILE *f2;
	FILE *f3;
	tree T=NULL;
	
	f1=fopen("parole1.txt","rt");
	if(f1==NULL)
		printf("Errore apertura file parole 1\n");

	f2=fopen("parole2.txt","rt");
	if(f2==NULL)
		printf("Errore apertura file parole2");
	
	f3=fopen("uscita.txt","wt");

	T=funzioneA(T,f1,f2);
	fclose(f1);
	fclose(f2);
	printf("\n\nAlbero\n\n");
	inorder(T);
	funzioneB(T,f3);
	fclose(f3);
}