/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.SQLiteTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.datastore.BigIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryStreamRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BitRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BooleanRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DateRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DecimalRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.FloatRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.IntegerRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NumericRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.RealRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SmallIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimeRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimestampRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TinyIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarCharRDBMSMapping;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf2Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod4;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class SQLiteAdapter
extends BaseDatastoreAdapter {
    protected static final int MAX_IDENTIFIER_LENGTH = 128;

    public SQLiteAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("FKInEndCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("AutoIncrementPkInCreateTableColumnDef");
        this.supportedOptions.add("OrderByNullsUsingColumnIsNull");
        this.supportedOptions.remove("TxIsolationReadCommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("RightOuterJoin");
        this.supportedOptions.remove("SomeAllAnySubqueries");
        this.supportedOptions.remove("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.remove("UpdateDeleteStmtAllowTableAliasInWhere");
        this.maxTableNameLength = 128;
        this.maxColumnNameLength = 128;
        this.maxConstraintNameLength = 128;
        this.maxIndexNameLength = 128;
    }

    @Override
    public String getVendorID() {
        return "sqlite";
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLiteTypeInfo sqlType = new SQLiteTypeInfo("double", 8, 0, null, null, null, 1, true, 3, false, false, false, "double", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new SQLiteTypeInfo("float", 6, 0, null, null, null, 1, true, 3, false, false, false, "float", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new SQLiteTypeInfo("decimal", 3, 0, null, null, null, 1, true, 3, false, false, false, "decimal", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new SQLiteTypeInfo("numeric", 2, 0, null, null, null, 1, true, 3, false, false, false, "numeric", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", 16, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", -7, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
        sqlType = new SQLiteTypeInfo("tinyint", -6, 0, null, null, null, 1, true, 3, false, false, false, "tinyint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new SQLiteTypeInfo("smallint", 5, 0, null, null, null, 1, true, 3, false, false, false, "smallint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)5, sqlType, true);
        sqlType = new SQLiteTypeInfo("bigint", -5, 0, null, null, null, 1, true, 3, false, false, false, "bigint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new SQLiteTypeInfo("char", 1, 255, null, null, null, 1, true, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new SQLiteTypeInfo("varchar", 12, 255, null, null, null, 1, true, 3, false, false, false, "varchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)12, sqlType, true);
        sqlType = new SQLiteTypeInfo("longvarchar", -1, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "longvarchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType, true);
        sqlType = new SQLiteTypeInfo("clob", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "clob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new SQLiteTypeInfo("date", 91, 0, null, null, null, 1, true, 3, false, false, false, "date", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        sqlType = new SQLiteTypeInfo("time", 92, 0, null, null, null, 1, true, 3, false, false, false, "time", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
        sqlType = new SQLiteTypeInfo("timestamp", 93, 0, null, null, null, 1, true, 3, false, false, false, "timestamp", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)93, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -2, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -3, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -4, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support CREATE SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support DROP SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String extendedSetting = idx.getValueForExtension("extended-setting");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ").append(idx.getUnique() ? "UNIQUE " : "").append("INDEX ");
        stringBuilder.append(factory.newTableIdentifier(idx.getName()).getFullyQualifiedName(true));
        stringBuilder.append(" ON ").append(idx.getTable().toString());
        stringBuilder.append(" ").append(idx.getColumnList(true));
        if (extendedSetting != null) {
            stringBuilder.append(" ").append(extendedSetting);
        }
        return stringBuilder.toString();
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ").append(tbl.getTable().toString());
        sql.append(" ").append(setSQL);
        return sql;
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE FROM " + tbl.getTable().toString();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 9223372036854775807 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT last_insert_rowid()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "autoincrement";
    }

    @Override
    public Class getAutoIncrementJavaTypeForType(Class type) {
        if (type.isPrimitive()) {
            return Integer.TYPE;
        }
        return Integer.class;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod4.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod4.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod4.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod4.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod5.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod5.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod5.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod6.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf2Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength3Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerDatastoreMapping(Boolean.class.getName(), BitRDBMSMapping.class, JDBCType.BIT, "BIT", true);
        this.registerDatastoreMapping(Boolean.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Boolean.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Byte.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerDatastoreMapping(Byte.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Character.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Double.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Double.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Float.class.getName(), FloatRDBMSMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerDatastoreMapping(Float.class.getName(), RealRDBMSMapping.class, JDBCType.REAL, "REAL", false);
        this.registerDatastoreMapping(Float.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Integer.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Long.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(Long.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Long.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Long.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Long.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Short.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Short.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(String.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerDatastoreMapping(String.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(String.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(String.class.getName(), LongVarcharRDBMSMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), ClobRDBMSMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerDatastoreMapping(String.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(String.class.getName(), NVarcharRDBMSMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), NCharRDBMSMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerDatastoreMapping(BigDecimal.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerDatastoreMapping(BigDecimal.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(BigInteger.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", true);
        this.registerDatastoreMapping(Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Time.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", true);
        this.registerDatastoreMapping(Time.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Time.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(Timestamp.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(java.util.Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Serializable.class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(Serializable.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(Serializable.class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(Serializable.class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(byte[].class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(byte[].class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerDatastoreMapping(File.class.getName(), BinaryStreamRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadDatastoreMappings(mgr, clr);
    }
}

