/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.EnhancementNucleusContextImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataManagerImpl;
import org.datanucleus.metadata.MetaDataMerger;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOMetaDataManager
extends MetaDataManagerImpl {
    private static final long serialVersionUID = -2276240352978344222L;
    public static final int ALL_JDO_LOCATIONS = 1;
    public static final int JDO_1_0_0_LOCATIONS = 2;
    public static final int JDO_1_0_1_LOCATIONS = 3;
    protected int locationDefinition = 1;
    protected MetaDataParser metaDataParser = null;
    protected Map<String, AbstractClassMetaData> ormClassMetaDataByClass = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByInterface = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected MetaDataRegisterClassListener registerListener;
    private static final char CLASS_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String METADATA_PACKAGE = "package";
    private static final String METADATA_LOCATION_METAINF = "/META-INF/package";
    private static final String METADATA_LOCATION_WEBINF = "/WEB-INF/package";

    public JDOMetaDataManager(NucleusContext ctxt) {
        super(ctxt);
        boolean useMetadataListener = false;
        Configuration conf = ctxt.getConfiguration();
        if (conf.getStringProperty("datanucleus.PersistenceUnitName") == null && ctxt instanceof PersistenceNucleusContextImpl && conf.getBooleanProperty("datanucleus.metadata.autoregistration")) {
            useMetadataListener = true;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            if (this.allowXML && this.allowAnnotations) {
                if (this.allowORM) {
                    String mappingName = this.getORMMappingName();
                    NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML,Annotations), XML-Validation=" + this.validateXML + ", XML-Suffices=(persistence=*." + this.getJDOFileSuffix() + ", orm=" + this.getORMFileSuffix() + ", query=*." + this.getJDOQueryFileSuffix() + ")" + (mappingName != null ? " mapping-name=" + mappingName : "") + ", JDO-listener=" + useMetadataListener));
                } else {
                    NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML,Annotations), XML-Validation=" + this.validateXML + ", XML-Suffices=(persistence=*." + this.getJDOFileSuffix() + ", query=*." + this.getJDOQueryFileSuffix() + "), JDO-listener=" + useMetadataListener));
                }
            } else if (this.allowXML && !this.allowAnnotations) {
                if (this.allowORM) {
                    String mappingName = this.getORMMappingName();
                    NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML), XML-Validation=" + this.validateXML + ", XML-Suffices=(persistence=*." + this.getJDOFileSuffix() + ", orm=" + this.getORMFileSuffix() + ", query=*." + this.getJDOQueryFileSuffix() + ")" + (mappingName != null ? " mapping-name=" + mappingName : "") + ", JDO-listener=" + useMetadataListener));
                } else {
                    NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML), XML-Validation=" + this.validateXML + ", XML-Suffices=(persistence=*." + this.getJDOFileSuffix() + ", query=*." + this.getJDOQueryFileSuffix() + "), JDO-listener=" + useMetadataListener));
                }
            } else if (!this.allowXML && this.allowAnnotations) {
                NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(Annotations), JDO-listener=" + useMetadataListener));
            } else {
                NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(NONE), JDO-listener=" + useMetadataListener));
            }
        }
        if (useMetadataListener) {
            NucleusLogger.METADATA.debug((Object)"Registering listener for metadata initialisation");
            this.registerListener = new MetaDataRegisterClassListener();
            EnhancementHelper.getInstance().addRegisterClassListener((EnhancementHelper.RegisterClassListener)this.registerListener);
        }
    }

    public void close() {
        if (this.registerListener != null) {
            NucleusLogger.METADATA.debug((Object)"Deregistering listener for metadata initialisation");
            EnhancementHelper.getInstance().removeRegisterClassListener((EnhancementHelper.RegisterClassListener)this.registerListener);
        }
        super.close();
        this.ormClassMetaDataByClass.clear();
        this.ormClassMetaDataByClass = null;
    }

    public void unloadMetaDataForClass(String className) {
        super.unloadMetaDataForClass(className);
        this.ormClassMetaDataByClass.remove(className);
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser((MetaDataManager)this, this.nucleusContext.getPluginManager(), this.validateXML, this.supportXMLNamespaces);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jdo");
    }

    public void registerFile(String fileURLString, FileMetaData filemd, ClassLoaderResolver clr) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerFetchPlansForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        if (filemd.getType() != MetadataFileType.JDO_QUERY_FILE) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                int j;
                PackageMetaData pmd = filemd.getPackage(i);
                for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                    DiscriminatorMetaData dismd;
                    ClassMetaData cmd = pmd.getClass(j);
                    if (this.classesWithoutPersistenceInfo.contains(cmd.getFullClassName())) {
                        this.classesWithoutPersistenceInfo.remove(cmd.getFullClassName());
                    }
                    if (filemd.getType() == MetadataFileType.JDO_FILE || filemd.getType() == MetadataFileType.ANNOTATIONS) {
                        this.registerMetaDataForClass(cmd.getFullClassName(), (AbstractClassMetaData)cmd);
                    } else if (filemd.getType() == MetadataFileType.JDO_ORM_FILE) {
                        this.ormClassMetaDataByClass.put(cmd.getFullClassName(), (AbstractClassMetaData)cmd);
                    }
                    if (cmd.getEntityName() != null) {
                        this.classMetaDataByEntityName.put(cmd.getEntityName(), cmd);
                    }
                    if (cmd.getInheritanceMetaData() == null || (dismd = cmd.getInheritanceMetaData().getDiscriminatorMetaData()) == null) continue;
                    if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                        this.classMetaDataByDiscriminatorName.put(cmd.getFullClassName(), cmd);
                        continue;
                    }
                    if (dismd.getStrategy() != DiscriminatorStrategy.VALUE_MAP || dismd.getValue() == null) continue;
                    this.classMetaDataByDiscriminatorName.put(dismd.getValue(), cmd);
                }
                for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                    InterfaceMetaData intfmd = pmd.getInterface(j);
                    if (filemd.getType() == MetadataFileType.JDO_FILE || filemd.getType() == MetadataFileType.ANNOTATIONS) {
                        this.registerMetaDataForClass(intfmd.getFullClassName(), (AbstractClassMetaData)intfmd);
                        continue;
                    }
                    if (filemd.getType() != MetadataFileType.JDO_ORM_FILE) continue;
                    this.ormClassMetaDataByClass.put(intfmd.getFullClassName(), (AbstractClassMetaData)intfmd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractClassMetaData loadMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        String className = c.getName();
        try {
            FileMetaData annFilemd;
            FileMetaData filemd;
            this.updateLock.lock();
            if (this.allowXML && (filemd = this.loadXMLMetaDataForClass(c, clr, null, this.getJDOFileSuffix(), MetadataFileType.JDO_FILE, true)) != null) {
                AbstractClassMetaData the_md;
                this.utilisedFileMetaData.add(filemd);
                AbstractClassMetaData abstractClassMetaData = the_md = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
                return abstractClassMetaData;
            }
            if (this.allowAnnotations && (annFilemd = this.loadAnnotationsForClass(c, clr, true, true)) != null) {
                if (c.isInterface()) {
                    InterfaceMetaData interfaceMetaData = annFilemd.getPackage(0).getInterface(0);
                    return interfaceMetaData;
                }
                ClassMetaData classMetaData = annFilemd.getPackage(0).getClass(0);
                return classMetaData;
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044043", (Object[])new Object[]{className}));
            }
            this.classesWithoutPersistenceInfo.add(className);
            AbstractClassMetaData abstractClassMetaData = null;
            return abstractClassMetaData;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        QueryMetaData qmd = super.getMetaDataForQuery(cls, clr, queryName);
        if (qmd != null) {
            return qmd;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        if (cls != null) {
            Object obj;
            AbstractClassMetaData cmd = this.getMetaDataForClass(cls, clr);
            if (cmd == null) {
                return null;
            }
            if (this.queryMetaDataByName != null && (obj = this.queryMetaDataByName.get(query_key)) != null) {
                return (QueryMetaData)obj;
            }
            if (this.allowXML) {
                ArrayList<String> locations = new ArrayList<String>();
                locations.addAll(this.getValidMetaDataLocationsForClass(this.getJDOQueryFileSuffix(), null, cls.getName()));
                for (String location : locations) {
                    Enumeration resources;
                    try {
                        resources = clr.getResources(location, cls.getClassLoader());
                    }
                    catch (IOException e) {
                        throw new NucleusException("Error loading resource", (Throwable)e).setFatal();
                    }
                    while (resources.hasMoreElements()) {
                        URL fileURL = (URL)resources.nextElement();
                        if (this.fileMetaDataByURLString.get(fileURL.toString()) != null) continue;
                        FileMetaData filemd = this.parseFile(fileURL);
                        filemd.setType(MetadataFileType.JDO_QUERY_FILE);
                        this.registerFile(fileURL.toString(), filemd, clr);
                    }
                    cmd = this.getMetaDataForClass(cls, clr);
                    if (this.queryMetaDataByName == null) continue;
                    qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key);
                    if (qmd != null) {
                        if (NucleusLogger.METADATA.isDebugEnabled()) {
                            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044053", (Object[])new Object[]{query_key, location}));
                        }
                        return qmd;
                    }
                    if (!NucleusLogger.METADATA.isDebugEnabled()) continue;
                    NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044050", (Object[])new Object[]{query_key, location}));
                }
            }
            return null;
        }
        ArrayList<String> locations = new ArrayList<String>();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.getJDOFileSuffix(), null, null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.getORMFileSuffix(), this.getORMMappingName(), null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.getJDOQueryFileSuffix(), null, null, false));
        for (String location : locations) {
            Enumeration resources;
            try {
                resources = clr.getResources(location, null);
            }
            catch (IOException e) {
                throw new NucleusException("Error loading resources", (Throwable)e).setFatal();
            }
            while (resources.hasMoreElements()) {
                URL fileURL = (URL)resources.nextElement();
                if (this.fileMetaDataByURLString.get(fileURL.toString()) != null) continue;
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd, clr);
            }
            if (this.queryMetaDataByName != null && (qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key)) != null) {
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044053", (Object[])new Object[]{query_key, location}));
                }
                return qmd;
            }
            if (!NucleusLogger.METADATA.isDebugEnabled()) continue;
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044050", (Object[])new Object[]{query_key, location}));
        }
        return null;
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String packageSequenceName) {
        SequenceMetaData seqmd = super.getMetaDataForSequence(clr, packageSequenceName);
        if (seqmd != null) {
            return seqmd;
        }
        String packageName = packageSequenceName;
        if (packageSequenceName.lastIndexOf(46) >= 0) {
            packageName = packageSequenceName.substring(0, packageSequenceName.lastIndexOf(46));
        }
        ArrayList<String> locations = new ArrayList<String>();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.getJDOFileSuffix(), null, packageName, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.getORMFileSuffix(), this.getORMMappingName(), packageName, false));
        for (String location : locations) {
            Enumeration resources;
            try {
                resources = clr.getResources(location, null);
            }
            catch (IOException e) {
                throw new NucleusException("Error loading resource", (Throwable)e).setFatal();
            }
            while (resources.hasMoreElements()) {
                URL fileURL = (URL)resources.nextElement();
                if (this.fileMetaDataByURLString.get(fileURL.toString()) != null) continue;
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd, clr);
            }
            if (this.sequenceMetaDataByPackageSequence != null) {
                seqmd = (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(packageSequenceName);
            }
            if (seqmd != null) {
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044053", (Object[])new Object[]{packageSequenceName, location}));
                }
                return seqmd;
            }
            if (!NucleusLogger.METADATA.isDebugEnabled()) continue;
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044051", (Object[])new Object[]{packageSequenceName, location}));
        }
        return null;
    }

    public void addORMDataToClass(Class c, ClassLoaderResolver clr) {
        FileMetaData filemdORM;
        if (this.getNucleusContext() instanceof EnhancementNucleusContextImpl) {
            return;
        }
        if (!this.allowORM) {
            return;
        }
        AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        AbstractClassMetaData ormCmd = this.ormClassMetaDataByClass.get(c.getName());
        if (ormCmd != null) {
            MetaDataMerger.mergeClassORMData((AbstractClassMetaData)cmd, (AbstractClassMetaData)ormCmd, (MetaDataManager)this);
            this.ormClassMetaDataByClass.remove(c.getName());
            return;
        }
        if (this.allowXML && (filemdORM = this.loadXMLMetaDataForClass(c, clr, this.getORMMappingName(), this.getORMFileSuffix(), MetadataFileType.JDO_ORM_FILE, false)) != null && (ormCmd = this.ormClassMetaDataByClass.get(c.getName())) != null) {
            MetaDataMerger.mergeFileORMData((FileMetaData)((FileMetaData)cmd.getPackageMetaData().getParent()), (FileMetaData)((FileMetaData)ormCmd.getPackageMetaData().getParent()));
            MetaDataMerger.mergeClassORMData((AbstractClassMetaData)cmd, (AbstractClassMetaData)ormCmd, (MetaDataManager)this);
            this.ormClassMetaDataByClass.remove(c.getName());
        }
    }

    protected FileMetaData loadXMLMetaDataForClass(Class pc_class, ClassLoaderResolver clr, String mappingModifier, String metadataFileExtension, MetadataFileType metadataType, boolean populate) {
        List<String> validLocations = this.getValidMetaDataLocationsForClass(metadataFileExtension, mappingModifier, pc_class.getName());
        block2: for (String location : validLocations) {
            Enumeration resources;
            try {
                resources = clr.getResources(location, pc_class.getClassLoader());
            }
            catch (IOException e) {
                throw new NucleusException("Error loading resource", (Throwable)e).setFatal();
            }
            if (!resources.hasMoreElements() && NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044049", (Object[])new Object[]{metadataFileExtension, pc_class.getName(), location}));
            }
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                if (url == null) continue;
                FileMetaData filemd = (FileMetaData)this.fileMetaDataByURLString.get(url.toString());
                if (filemd == null) {
                    filemd = this.parseFile(url);
                    if (filemd.getType() != metadataType) {
                        NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044045", (Object[])new Object[]{url, filemd.getType(), metadataType}));
                        filemd = null;
                        continue block2;
                    }
                    this.registerFile(url.toString(), filemd, clr);
                    if (populate) {
                        this.populateFileMetaData(filemd, clr, pc_class.getClassLoader());
                    }
                }
                if ((filemd.getType() != MetadataFileType.JDO_FILE || this.classMetaDataByClass.get(pc_class.getName()) == null) && (filemd.getType() != MetadataFileType.JDO_ORM_FILE || this.ormClassMetaDataByClass.get(pc_class.getName()) == null)) continue;
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044052", (Object[])new Object[]{metadataFileExtension, pc_class.getName(), url}));
                }
                return filemd;
            }
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044048", (Object[])new Object[]{metadataFileExtension, pc_class.getName()}));
        }
        return null;
    }

    public List<String> getValidMetaDataLocationsForPackage(String fileExtension, String fileModifier, String packageName) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, packageName, false);
    }

    public List<String> getValidMetaDataLocationsForClass(String fileExtension, String fileModifier, String className) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, className, true);
    }

    List<String> getValidMetaDataLocationsForItem(String fileExtension, String fileModifier, String itemName, boolean isClass) {
        ArrayList<String> locations = new ArrayList<String>();
        if (fileExtension == null) {
            fileExtension = "jdo";
        }
        StringTokenizer tokens = new StringTokenizer(fileExtension, ",");
        while (tokens.hasMoreTokens()) {
            locations.addAll(this.getValidMetaDataLocationsForSingleExtension(tokens.nextToken(), fileModifier, itemName, isClass));
        }
        return locations;
    }

    private List<String> getValidMetaDataLocationsForSingleExtension(String fileExtension, String fileModifier, String itemName, boolean isClass) {
        ArrayList<String> locations = new ArrayList<String>();
        String suffix = null;
        if (fileExtension == null) {
            fileExtension = "jdo";
        }
        suffix = fileModifier != null ? "-" + fileModifier + '.' + fileExtension : '.' + fileExtension;
        if (this.locationDefinition == 1 || this.locationDefinition == 3) {
            locations.add(METADATA_LOCATION_METAINF + suffix);
            locations.add(METADATA_LOCATION_WEBINF + suffix);
            locations.add("/package" + suffix);
        }
        if (itemName != null && itemName.length() > 0) {
            int separatorPosition = itemName.indexOf(46);
            if (separatorPosition < 0) {
                if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                    locations.add('/' + itemName + '/' + METADATA_PACKAGE + suffix);
                }
                if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                    locations.add('/' + itemName + suffix);
                }
            } else {
                while (separatorPosition >= 0) {
                    String name = itemName.substring(0, separatorPosition);
                    if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                        locations.add('/' + name.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                        locations.add('/' + name.replace('.', '/') + suffix);
                    }
                    if ((separatorPosition = itemName.indexOf(46, separatorPosition + 1)) >= 0) continue;
                    if (!(isClass || this.locationDefinition != 1 && this.locationDefinition != 3)) {
                        locations.add('/' + itemName.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition != 1 && this.locationDefinition != 2) continue;
                    locations.add('/' + itemName.replace('.', '/') + suffix);
                }
            }
        }
        return locations;
    }

    private String getORMMappingName() {
        String mappingName = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.mapping");
        return StringUtils.isWhitespace((String)mappingName) ? null : mappingName;
    }

    private String getJDOFileSuffix() {
        String suffix = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.metadata.jdoFileExtension");
        return StringUtils.isWhitespace((String)suffix) ? "jdo" : suffix;
    }

    private String getORMFileSuffix() {
        String suffix = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.metadata.ormFileExtension");
        return StringUtils.isWhitespace((String)suffix) ? "orm" : suffix;
    }

    private String getJDOQueryFileSuffix() {
        String suffix = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.metadata.jdoqueryFileExtension");
        return StringUtils.isWhitespace((String)suffix) ? "jdoquery" : suffix;
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        if (c == null || !c.isInterface()) {
            return null;
        }
        InterfaceMetaData imd = (InterfaceMetaData)this.getMetaDataForClassInternal(c, clr);
        if (imd != null) {
            this.populateAbstractClassMetaData((AbstractClassMetaData)imd, clr, c.getClassLoader());
            this.initialiseAbstractClassMetaData((AbstractClassMetaData)imd, clr);
            if (!this.utilisedFileMetaData.isEmpty()) {
                for (FileMetaData filemd : this.utilisedFileMetaData) {
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
            }
        }
        this.utilisedFileMetaData.clear();
        return imd;
    }

    public boolean isPersistentInterface(String name) {
        AbstractClassMetaData acmd = (AbstractClassMetaData)this.classMetaDataByClass.get(name);
        return acmd != null && acmd instanceof InterfaceMetaData;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null && cmd.getFullClassName().equals(implName);
    }

    public boolean isPersistentDefinitionImplementation(String implName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByClass.get(implName);
        return cmd != null && cmd.isImplementationOfPersistentDefinition();
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null ? cmd.getFullClassName() : null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
        ClassMetaData cmd = new ClassMetaData(imd, ClassUtils.getClassNameForClass((Class)implClass), true);
        cmd.addImplements(new ImplementsMetaData(imd.getFullClassName()));
        this.registerMetaDataForClass(cmd.getFullClassName(), (AbstractClassMetaData)cmd);
        this.classMetaDataByInterface.put(imd.getFullClassName(), (AbstractClassMetaData)cmd);
        this.initialiseClassMetaData(cmd, implClass, clr);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044044", (Object[])new Object[]{implClass.getName()}));
        }
        this.classesWithoutPersistenceInfo.remove(implClass.getName());
    }

    public void registerImplementationOfAbstractClass(ClassMetaData cmd, Class implClass, ClassLoaderResolver clr) {
        ClassMetaData implCmd = new ClassMetaData(cmd, ClassUtils.getClassNameForClass((Class)implClass));
        this.registerMetaDataForClass(implCmd.getFullClassName(), (AbstractClassMetaData)implCmd);
        this.initialiseClassMetaData(implCmd, implClass, clr);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044044", (Object[])new Object[]{implClass.getName()}));
        }
        this.classesWithoutPersistenceInfo.remove(implClass.getName());
    }

    private class MetaDataRegisterClassListener
    implements EnhancementHelper.RegisterClassListener {
        private MetaDataRegisterClassListener() {
        }

        public void registerClass(Class registeredClass) {
            NucleusLogger.METADATA.debug((Object)("Listener found initialisation for persistable class " + registeredClass.getName()));
            try {
                JDOMetaDataManager.this.getMetaDataForClass(registeredClass, JDOMetaDataManager.this.nucleusContext.getClassLoaderResolver(registeredClass.getClassLoader()));
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn((Object)("Listener attempted to load metadata for " + registeredClass.getName() + " but an exception was thrown. Ignoring this class"), (Throwable)e);
            }
        }
    }
}

