/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.AttributeSpecification;
import aima.learning.framework.NumericAttributeSpecification;
import aima.learning.framework.StringAttributeSpecification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataSetSpecification {
    List<AttributeSpecification> attributeSpecifications = new ArrayList<AttributeSpecification>();
    private String targetAttribute;

    public boolean isValid(List<String> uncheckedAttributes) {
        if (this.attributeSpecifications.size() != uncheckedAttributes.size()) {
            throw new RuntimeException("size mismatch specsize = " + this.attributeSpecifications.size() + " attrbutes size = " + uncheckedAttributes.size());
        }
        Iterator<AttributeSpecification> attributeSpecIter = this.attributeSpecifications.iterator();
        Iterator<String> valueIter = uncheckedAttributes.iterator();
        while (valueIter.hasNext() && attributeSpecIter.hasNext()) {
            if (attributeSpecIter.next().isValid(valueIter.next())) continue;
            return false;
        }
        return true;
    }

    public String getTarget() {
        return this.targetAttribute;
    }

    public List<String> getPossibleAttributeValues(String attributeName) {
        for (AttributeSpecification as : this.attributeSpecifications) {
            if (!as.getAttributeName().equals(attributeName)) continue;
            return ((StringAttributeSpecification)as).possibleAttributeValues();
        }
        throw new RuntimeException("No such attribute" + attributeName);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeSpecification as : this.attributeSpecifications) {
            names.add(as.getAttributeName());
        }
        return names;
    }

    public void defineStringAttribute(String name, String[] attributeValues) {
        this.attributeSpecifications.add(new StringAttributeSpecification(name, attributeValues));
        this.setTarget(name);
    }

    public void setTarget(String target) {
        this.targetAttribute = target;
    }

    public AttributeSpecification getAttributeSpecFor(String name) {
        for (AttributeSpecification spec : this.attributeSpecifications) {
            if (!spec.getAttributeName().equals(name)) continue;
            return spec;
        }
        throw new RuntimeException("no attribute spec for  " + name);
    }

    public void defineNumericAttribute(String name) {
        this.attributeSpecifications.add(new NumericAttributeSpecification(name));
    }

    public List<String> getNamesOfStringAttributes() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeSpecification spec : this.attributeSpecifications) {
            if (!(spec instanceof StringAttributeSpecification)) continue;
            names.add(spec.getAttributeName());
        }
        return names;
    }
}

