/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.LinkedHashSet;
import java.util.Set;

public class VariableCollector
implements FOLVisitor {
    public Set<Variable> collectAllVariables(Sentence sentence) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        sentence.accept(this, variables);
        return variables;
    }

    public Set<Variable> collectAllVariables(Term aTerm) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        aTerm.accept(this, variables);
        return variables;
    }

    public Set<Variable> collectAllVariables(Clause aClause) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        for (Literal l : aClause.getLiterals()) {
            l.getAtomicSentence().accept(this, variables);
        }
        return variables;
    }

    public Set<Variable> collectAllVariables(Chain aChain) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        for (Literal l : aChain.getLiterals()) {
            l.getAtomicSentence().accept(this, variables);
        }
        return variables;
    }

    @Override
    public Object visitVariable(Variable var, Object arg) {
        Set variables = (Set)arg;
        variables.add(var);
        return var;
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        Set variables = (Set)arg;
        variables.addAll(sentence.getVariables());
        sentence.getQuantified().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object arg) {
        for (Term t : predicate.getTerms()) {
            t.accept(this, arg);
        }
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        equality.getTerm1().accept(this, arg);
        equality.getTerm2().accept(this, arg);
        return equality;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        for (Term t : function.getTerms()) {
            t.accept(this, arg);
        }
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        sentence.getNegated().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        sentence.getFirst().accept(this, arg);
        sentence.getSecond().accept(this, arg);
        return sentence;
    }
}

