/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofStep;
import java.util.List;

public class ProofPrinter {
    public static String printProof(Proof aProof) {
        StringBuilder sb = new StringBuilder();
        sb.append("Proof, Answer Bindings: ");
        sb.append(aProof.getAnswerBindings());
        sb.append("\n");
        List<ProofStep> steps = aProof.getSteps();
        int maxStepWidth = "Step".length();
        int maxProofWidth = "Proof".length();
        int maxJustificationWidth = "Justification".length();
        for (ProofStep step : steps) {
            String sn = "" + step.getStepNumber();
            if (sn.length() > maxStepWidth) {
                maxStepWidth = sn.length();
            }
            if (step.getProof().length() > maxProofWidth) {
                maxProofWidth = step.getProof().length();
            }
            if (step.getJustification().length() <= maxJustificationWidth) continue;
            maxJustificationWidth = step.getJustification().length();
        }
        String f = "|%-" + ++maxStepWidth + "s| %-" + ++maxProofWidth + "s|%-" + ++maxJustificationWidth + "s|\n";
        int barWidth = 5 + maxStepWidth + maxProofWidth + maxJustificationWidth;
        StringBuilder bar = new StringBuilder();
        for (int i = 0; i < barWidth; ++i) {
            bar.append("-");
        }
        bar.append("\n");
        sb.append((CharSequence)bar);
        sb.append(String.format(f, "Step", "Proof", "Justification"));
        sb.append((CharSequence)bar);
        for (ProofStep step : steps) {
            sb.append(String.format(f, "" + step.getStepNumber(), step.getProof(), step.getJustification()));
        }
        sb.append((CharSequence)bar);
        return sb.toString();
    }
}

