/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotSentence
implements Sentence {
    private Sentence negated;
    private List<Sentence> args = new ArrayList<Sentence>();
    private String stringRep = null;
    private int hashCode = 0;

    public NotSentence(Sentence negated) {
        this.negated = negated;
        this.args.add(negated);
    }

    public Sentence getNegated() {
        return this.negated;
    }

    @Override
    public String getSymbolicName() {
        return "NOT";
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<Sentence> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitNotSentence(this, arg);
    }

    @Override
    public NotSentence copy() {
        return new NotSentence(this.negated.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotSentence ns = (NotSentence)o;
        return ns.negated.equals(this.negated);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.negated.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append("NOT(");
            sb.append(this.negated.toString());
            sb.append(")");
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

