/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.UnarySentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolClassifier;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import aima.util.LogicUtils;
import aima.util.SetOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DPLL {
    private static final Converter<Symbol> SYMBOL_CONVERTER = new Converter();

    public boolean dpllSatisfiable(Sentence s) {
        return this.dpllSatisfiable(s, new Model());
    }

    public boolean dpllSatisfiable(String string) {
        Sentence sen = (Sentence)new PEParser().parse(string);
        return this.dpllSatisfiable(sen, new Model());
    }

    public boolean dpllSatisfiable(Sentence s, Model m) {
        Set<Sentence> clauses = new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(s));
        List<Symbol> symbols = SYMBOL_CONVERTER.setToList(new SymbolCollector().getSymbolsIn(s));
        return this.dpll(clauses, symbols, m);
    }

    private boolean dpll(Set<Sentence> clauses, List symbols, Model model) {
        List<Sentence> clauseList = new Converter<Sentence>().setToList(clauses);
        if (this.areAllClausesTrue(model, clauseList)) {
            return true;
        }
        if (this.isEvenOneClauseFalse(model, clauseList)) {
            return false;
        }
        SymbolValuePair svp = this.findPureSymbolValuePair(clauseList, model, symbols);
        if (svp.notNull()) {
            List newSymbols = (List)((ArrayList)symbols).clone();
            newSymbols.remove(new Symbol(svp.symbol.getValue()));
            Model newModel = model.extend(new Symbol(svp.symbol.getValue()), (boolean)svp.value);
            return this.dpll(clauses, newSymbols, newModel);
        }
        SymbolValuePair svp2 = this.findUnitClause(clauseList, model, symbols);
        if (svp2.notNull()) {
            List newSymbols = (List)((ArrayList)symbols).clone();
            newSymbols.remove(new Symbol(svp2.symbol.getValue()));
            Model newModel = model.extend(new Symbol(svp2.symbol.getValue()), (boolean)svp2.value);
            return this.dpll(clauses, newSymbols, newModel);
        }
        Symbol symbol = (Symbol)symbols.get(0);
        List newSymbols = (List)((ArrayList)symbols).clone();
        newSymbols.remove(0);
        return this.dpll(clauses, newSymbols, model.extend(symbol, true)) || this.dpll(clauses, newSymbols, model.extend(symbol, false));
    }

    private boolean isEvenOneClauseFalse(Model model, List clauseList) {
        for (int i = 0; i < clauseList.size(); ++i) {
            Sentence clause = (Sentence)clauseList.get(i);
            if (!model.isFalse(clause)) continue;
            return true;
        }
        return false;
    }

    private boolean areAllClausesTrue(Model model, List clauseList) {
        for (int i = 0; i < clauseList.size(); ++i) {
            Sentence clause = (Sentence)clauseList.get(i);
            if (this.isClauseTrueInModel(clause, model)) continue;
            return false;
        }
        return true;
    }

    private boolean isClauseTrueInModel(Sentence clause, Model model) {
        List<Symbol> positiveSymbols = SYMBOL_CONVERTER.setToList(new SymbolClassifier().getPositiveSymbolsIn(clause));
        List<Symbol> negativeSymbols = SYMBOL_CONVERTER.setToList(new SymbolClassifier().getNegativeSymbolsIn(clause));
        for (Symbol symbol : positiveSymbols) {
            if (!model.isTrue(symbol)) continue;
            return true;
        }
        for (Symbol symbol : negativeSymbols) {
            if (!model.isFalse(symbol)) continue;
            return true;
        }
        return false;
    }

    public List<Sentence> clausesWithNonTrueValues(List<Sentence> clauseList, Model model) {
        ArrayList<Sentence> clausesWithNonTrueValues = new ArrayList<Sentence>();
        for (int i = 0; i < clauseList.size(); ++i) {
            Sentence clause = clauseList.get(i);
            if (this.isClauseTrueInModel(clause, model) || clausesWithNonTrueValues.contains(clause)) continue;
            clausesWithNonTrueValues.add(clause);
        }
        return clausesWithNonTrueValues;
    }

    public SymbolValuePair findPureSymbolValuePair(List<Sentence> clauseList, Model model, List symbols) {
        List<Sentence> clausesWithNonTrueValues = this.clausesWithNonTrueValues(clauseList, model);
        Sentence nonTrueClauses = LogicUtils.chainWith("AND", clausesWithNonTrueValues);
        Set<Symbol> symbolsAlreadyAssigned = model.getAssignedSymbols();
        List<Symbol> purePositiveSymbols = SYMBOL_CONVERTER.setToList(new SetOps<Symbol>().difference(new SymbolClassifier().getPurePositiveSymbolsIn(nonTrueClauses), symbolsAlreadyAssigned));
        List<Symbol> pureNegativeSymbols = SYMBOL_CONVERTER.setToList(new SetOps<Symbol>().difference(new SymbolClassifier().getPureNegativeSymbolsIn(nonTrueClauses), symbolsAlreadyAssigned));
        if (purePositiveSymbols.size() == 0 && pureNegativeSymbols.size() == 0) {
            return new SymbolValuePair();
        }
        if (purePositiveSymbols.size() > 0) {
            Symbol symbol = new Symbol(purePositiveSymbols.get(0).getValue());
            if (pureNegativeSymbols.contains(symbol)) {
                throw new RuntimeException("Symbol " + symbol.getValue() + "misclassified");
            }
            return new SymbolValuePair(symbol, true);
        }
        Symbol symbol = new Symbol(pureNegativeSymbols.get(0).getValue());
        if (purePositiveSymbols.contains(symbol)) {
            throw new RuntimeException("Symbol " + symbol.getValue() + "misclassified");
        }
        return new SymbolValuePair(symbol, false);
    }

    private SymbolValuePair findUnitClause(List clauseList, Model model, List symbols) {
        for (int i = 0; i < clauseList.size(); ++i) {
            UnarySentence sentence;
            Sentence negated;
            Sentence clause = (Sentence)clauseList.get(i);
            if (clause instanceof Symbol && !model.getAssignedSymbols().contains(clause)) {
                return new SymbolValuePair(new Symbol(((Symbol)clause).getValue()), true);
            }
            if (!(clause instanceof UnarySentence) || !((negated = (sentence = (UnarySentence)clause).getNegated()) instanceof Symbol) || model.getAssignedSymbols().contains(negated)) continue;
            return new SymbolValuePair(new Symbol(((Symbol)negated).getValue()), false);
        }
        return new SymbolValuePair();
    }

    public class SymbolValuePair {
        public Symbol symbol;
        public Boolean value;

        public SymbolValuePair() {
            this.symbol = null;
            this.value = null;
        }

        public SymbolValuePair(Symbol symbol, boolean bool) {
            this.symbol = symbol;
            this.value = new Boolean(bool);
        }

        public boolean notNull() {
            return this.symbol != null && this.value != null;
        }

        public String toString() {
            String symbolString = this.symbol == null ? "NULL" : this.symbol.toString();
            String valueString = this.value == null ? "NULL" : this.value.toString();
            return symbolString + " -> " + valueString;
        }
    }
}

