/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.BayesNet;
import aima.probability.Query;
import aima.util.Util;
import java.util.Hashtable;
import java.util.List;

public class EnumerationAsk {
    public static double[] ask(Query q, BayesNet net) {
        String queryVariable = q.getQueryVariable();
        Hashtable<String, Boolean> evidenceVariables = q.getEvidenceVariables();
        double[] probDist = new double[2];
        evidenceVariables.put(q.getQueryVariable(), new Boolean(true));
        probDist[0] = EnumerationAsk.enumerateAll(net, net.getVariables(), evidenceVariables);
        evidenceVariables.put(q.getQueryVariable(), new Boolean(false));
        probDist[1] = EnumerationAsk.enumerateAll(net, net.getVariables(), evidenceVariables);
        double[] normalized = Util.normalize(probDist);
        return normalized;
    }

    private static double enumerateAll(BayesNet net, List unprocessedVariables, Hashtable<String, Boolean> evidenceVariables) {
        if (unprocessedVariables.size() == 0) {
            return 1.0;
        }
        String Y = (String)unprocessedVariables.get(0);
        if (evidenceVariables.keySet().contains(Y)) {
            double probYGivenParents = net.probabilityOf(Y, evidenceVariables.get(Y), evidenceVariables);
            double secondTerm = EnumerationAsk.enumerateAll(net, Util.rest(unprocessedVariables), evidenceVariables);
            return probYGivenParents * secondTerm;
        }
        double sigma = 0.0;
        Hashtable<String, Boolean> clone1 = EnumerationAsk.cloneEvidenceVariables(evidenceVariables);
        clone1.put(Y, Boolean.TRUE);
        double probYTrueGivenParents = net.probabilityOf(Y, Boolean.TRUE, clone1);
        double secondTerm = EnumerationAsk.enumerateAll(net, Util.rest(unprocessedVariables), clone1);
        double trueProbabilityY = probYTrueGivenParents * secondTerm;
        Hashtable<String, Boolean> clone2 = EnumerationAsk.cloneEvidenceVariables(evidenceVariables);
        clone2.put(Y, Boolean.FALSE);
        double probYFalseGivenParents = net.probabilityOf(Y, Boolean.FALSE, clone2);
        secondTerm = EnumerationAsk.enumerateAll(net, Util.rest(unprocessedVariables), clone2);
        double falseProbabilityY = probYFalseGivenParents * secondTerm;
        sigma = trueProbabilityY + falseProbabilityY;
        return sigma;
    }

    private static Hashtable<String, Boolean> cloneEvidenceVariables(Hashtable<String, Boolean> evidence) {
        Hashtable<String, Boolean> cloned = new Hashtable<String, Boolean>();
        for (String key : evidence.keySet()) {
            Boolean bool = evidence.get(key);
            if (bool.equals(Boolean.TRUE)) {
                cloned.put(key, Boolean.TRUE);
                continue;
            }
            if (!evidence.get(key).equals(Boolean.FALSE)) continue;
            cloned.put(key, Boolean.FALSE);
        }
        return cloned;
    }
}

