/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DecisionList;
import junit.framework.TestCase;

public class DecisionListTest
extends TestCase {
    public void testDecisonListWithNoTestsReturnsDefaultValue() throws Exception {
        DecisionList dlist = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionListTest.assertEquals("No", dlist.predict(ds.getExample(0)));
    }

    public void testDecisionListWithSingleTestReturnsTestValueIfTestSuccessful() throws Exception {
        DecisionList dlist = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DLTest test = new DLTest();
        test.add("type", "French");
        dlist.add(test, "test1success");
        DecisionListTest.assertEquals("test1success", dlist.predict(ds.getExample(0)));
    }

    public void testDecisionListFallsThruToNextTestIfOneDoesntMatch() throws Exception {
        DecisionList dlist = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DLTest test1 = new DLTest();
        test1.add("type", "Thai");
        dlist.add(test1, "test1success");
        DLTest test2 = new DLTest();
        test2.add("type", "French");
        dlist.add(test2, "test2success");
        DecisionListTest.assertEquals("test2success", dlist.predict(ds.getExample(0)));
    }

    public void testDecisionListFallsThruToDefaultIfNoTestMatches() throws Exception {
        DecisionList dlist = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DLTest test1 = new DLTest();
        test1.add("type", "Thai");
        dlist.add(test1, "test1success");
        DLTest test2 = new DLTest();
        test2.add("type", "Burger");
        dlist.add(test2, "test2success");
        DecisionListTest.assertEquals("No", dlist.predict(ds.getExample(0)));
    }

    public void testDecisionListHandlesEmptyDataSet() throws Exception {
        DecisionList dlist = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DLTest test1 = new DLTest();
        test1.add("type", "Thai");
        dlist.add(test1, "test1success");
    }

    public void testDecisionListMerge() throws Exception {
        DecisionList dlist1 = new DecisionList("Yes", "No");
        DecisionList dlist2 = new DecisionList("Yes", "No");
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DLTest test1 = new DLTest();
        test1.add("type", "Thai");
        dlist1.add(test1, "test1success");
        DLTest test2 = new DLTest();
        test2.add("type", "French");
        dlist2.add(test2, "test2success");
        DecisionList dlist3 = dlist1.mergeWith(dlist2);
        DecisionListTest.assertEquals("test2success", dlist3.predict(ds.getExample(0)));
    }
}

