/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.VariableCollector;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Variable;
import java.util.Set;
import junit.framework.TestCase;

public class VariableCollectorTest
extends TestCase {
    private Sentence sentence;
    FOLParser parser;
    VariableCollector vc;

    @Override
    public void setUp() {
        this.parser = new FOLParser(DomainFactory.crusadesDomain());
        this.vc = new VariableCollector();
    }

    public void testSimplepredicate() {
        Set<Variable> variables = this.vc.collectAllVariables(this.parser.parse("King(x)"));
        VariableCollectorTest.assertEquals(1, variables.size());
        VariableCollectorTest.assertTrue(variables.contains(new Variable("x")));
    }

    public void testMultipleVariables() {
        Set<Variable> variables = this.vc.collectAllVariables(this.parser.parse("BrotherOf(x) = EnemyOf(y)"));
        VariableCollectorTest.assertEquals(2, variables.size());
        VariableCollectorTest.assertTrue(variables.contains(new Variable("x")));
        VariableCollectorTest.assertTrue(variables.contains(new Variable("y")));
    }

    public void testQuantifiedVariables() {
        Set<Variable> variables = this.vc.collectAllVariables(this.parser.parse("FORALL x,y,z (BrotherOf(x) = EnemyOf(y))"));
        VariableCollectorTest.assertEquals(3, variables.size());
        VariableCollectorTest.assertTrue(variables.contains(new Variable("x")));
        VariableCollectorTest.assertTrue(variables.contains(new Variable("y")));
        VariableCollectorTest.assertTrue(variables.contains(new Variable("z")));
    }
}

