/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import junit.framework.TestCase;

public class ModelTest
extends TestCase {
    private Model m;
    private PEParser parser;
    Sentence trueSentence;
    Sentence falseSentence;
    Sentence andSentence;
    Sentence orSentence;
    Sentence impliedSentence;
    Sentence biConditionalSentence;

    @Override
    public void setUp() {
        this.parser = new PEParser();
        this.trueSentence = (Sentence)this.parser.parse("true");
        this.falseSentence = (Sentence)this.parser.parse("false");
        this.andSentence = (Sentence)this.parser.parse("(P  AND  Q)");
        this.orSentence = (Sentence)this.parser.parse("(P  OR  Q)");
        this.impliedSentence = (Sentence)this.parser.parse("(P  =>  Q)");
        this.biConditionalSentence = (Sentence)this.parser.parse("(P  <=>  Q)");
        this.m = new Model();
    }

    public void testEmptyModel() {
        ModelTest.assertEquals(null, this.m.getStatus(new Symbol("P")));
        ModelTest.assertEquals(true, this.m.isUnknown((Sentence)new Symbol("P")));
    }

    public void testExtendModel() {
        String p = "P";
        this.m = this.m.extend(new Symbol(p), true);
        ModelTest.assertEquals(Boolean.TRUE, this.m.getStatus(new Symbol("P")));
    }

    public void testTrueFalseEvaluation() {
        ModelTest.assertEquals(true, this.m.isTrue(this.trueSentence));
        ModelTest.assertEquals(false, this.m.isFalse(this.trueSentence));
        ModelTest.assertEquals(false, this.m.isTrue(this.falseSentence));
        ModelTest.assertEquals(true, this.m.isFalse(this.falseSentence));
    }

    public void testSentenceStatusWhenPTrueAndQTrue() {
        String p = "P";
        String q = "Q";
        this.m = this.m.extend(new Symbol(p), true);
        this.m = this.m.extend(new Symbol(q), true);
        ModelTest.assertEquals(true, this.m.isTrue(this.andSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.orSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPFalseAndQFalse() {
        String p = "P";
        String q = "Q";
        this.m = this.m.extend(new Symbol(p), false);
        this.m = this.m.extend(new Symbol(q), false);
        ModelTest.assertEquals(true, this.m.isFalse(this.andSentence));
        ModelTest.assertEquals(true, this.m.isFalse(this.orSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPTrueAndQFalse() {
        String p = "P";
        String q = "Q";
        this.m = this.m.extend(new Symbol(p), true);
        this.m = this.m.extend(new Symbol(q), false);
        ModelTest.assertEquals(true, this.m.isFalse(this.andSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.orSentence));
        ModelTest.assertEquals(true, this.m.isFalse(this.impliedSentence));
        ModelTest.assertEquals(true, this.m.isFalse(this.biConditionalSentence));
    }

    public void testSentenceStatusWhenPFalseAndQTrue() {
        String p = "P";
        String q = "Q";
        this.m = this.m.extend(new Symbol(p), false);
        this.m = this.m.extend(new Symbol(q), true);
        ModelTest.assertEquals(true, this.m.isFalse(this.andSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.orSentence));
        ModelTest.assertEquals(true, this.m.isTrue(this.impliedSentence));
        ModelTest.assertEquals(true, this.m.isFalse(this.biConditionalSentence));
    }

    public void testComplexSentence() {
        String p = "P";
        String q = "Q";
        this.m = this.m.extend(new Symbol(p), true);
        this.m = this.m.extend(new Symbol(q), false);
        Sentence sent = (Sentence)this.parser.parse("((P OR Q) AND  (P => Q))");
        Sentence sent2 = (Sentence)this.parser.parse("((P OR Q) AND  (Q))");
        ModelTest.assertFalse(this.m.isTrue(sent));
        ModelTest.assertTrue(this.m.isFalse(sent));
    }
}

