/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.eightpuzzle;

import aima.search.eightpuzzle.EightPuzzleBoard;
import aima.search.eightpuzzle.EightPuzzleSuccessorFunction;
import aima.search.framework.Successor;
import java.util.List;
import junit.framework.TestCase;

public class EightPuzzleSuccessorFunctionTest
extends TestCase {
    EightPuzzleBoard board;
    EightPuzzleSuccessorFunction func = new EightPuzzleSuccessorFunction();

    @Override
    public void setUp() {
        this.board = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 4, 0, 6, 7, 8});
    }

    public void testGenerateCorrect3successors() {
        List successors = this.func.getSuccessors(this.board);
        EightPuzzleSuccessorFunctionTest.assertEquals(3, successors.size());
        EightPuzzleBoard expectedFirst = new EightPuzzleBoard(new int[]{1, 2, 0, 3, 4, 5, 6, 7, 8});
        EightPuzzleBoard actualFirst = (EightPuzzleBoard)((Successor)successors.get(0)).getState();
        EightPuzzleSuccessorFunctionTest.assertEquals(expectedFirst, actualFirst);
        EightPuzzleSuccessorFunctionTest.assertEquals(EightPuzzleBoard.UP, ((Successor)successors.get(0)).getAction());
        EightPuzzleBoard expectedSecond = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 4, 8, 6, 7, 0});
        EightPuzzleBoard actualSecond = (EightPuzzleBoard)((Successor)successors.get(1)).getState();
        EightPuzzleSuccessorFunctionTest.assertEquals(expectedSecond, actualSecond);
        EightPuzzleSuccessorFunctionTest.assertEquals(EightPuzzleBoard.DOWN, ((Successor)successors.get(1)).getAction());
        EightPuzzleBoard expectedThird = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 0, 4, 6, 7, 8});
        EightPuzzleBoard actualThird = (EightPuzzleBoard)((Successor)successors.get(2)).getState();
        EightPuzzleSuccessorFunctionTest.assertEquals(expectedThird, actualThird);
        EightPuzzleSuccessorFunctionTest.assertEquals(EightPuzzleBoard.LEFT, ((Successor)successors.get(2)).getAction());
    }

    public void testGenerateCorrectWhenGapMovedRightward() {
        this.board.moveGapLeft();
        EightPuzzleSuccessorFunctionTest.assertEquals(new EightPuzzleBoard(new int[]{1, 2, 5, 3, 0, 4, 6, 7, 8}), this.board);
        List successors = this.func.getSuccessors(this.board);
        EightPuzzleSuccessorFunctionTest.assertEquals(4, successors.size());
        EightPuzzleBoard expectedFourth = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 4, 0, 6, 7, 8});
        EightPuzzleBoard actualFourth = (EightPuzzleBoard)((Successor)successors.get(3)).getState();
        EightPuzzleSuccessorFunctionTest.assertEquals(expectedFourth, actualFourth);
        EightPuzzleSuccessorFunctionTest.assertEquals(EightPuzzleBoard.RIGHT, ((Successor)successors.get(3)).getAction());
    }
}

