/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.TableDrivenVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class TableDrivenVaccumAgentTest
extends TestCase {
    private TableDrivenVaccumAgent agent;
    private StringBuffer envChanges;

    @Override
    public void setUp() {
        this.agent = new TableDrivenVaccumAgent();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                TableDrivenVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals("RightLeftRightNoOP", this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                TableDrivenVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals("RightSuckLeftNoOP", this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                TableDrivenVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals("SuckRightLeftNoOP", this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                TableDrivenVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.stepUntilDone();
        TableDrivenVaccumAgentTest.assertEquals("SuckRightSuckNoOP", this.envChanges.toString());
    }
}

