/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXArrow;
import fxgraph.FXEdgeWayPoint;
import fxgraph.FXGraph;
import fxgraph.FXNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class FXEdge {
    FXGraph graph;
    FXNode source;
    FXNode destination;
    private double weight;
    Node displayShape;
    private double positionMiddleLineX;
    private double positionMiddleLineY;
    private double endArrowX;
    private double endArrowY;
    Label lblWeight;
    List<FXEdgeWayPoint> wayPoints = new ArrayList<FXEdgeWayPoint>();
    Map<FXEdgeWayPoint, Node> wayPointHandles = new HashMap<FXEdgeWayPoint, Node>();
    private boolean oriented = true;
    SharePreferencesHandler sharePreferencesHandler;

    public FXEdge(FXGraph aGraph, FXNode aSource, FXNode aDestination) {
        this.graph = aGraph;
        this.source = aSource;
        this.destination = aDestination;
        this.sharePreferencesHandler = new SharePreferencesHandler();
        this.lblWeight = new Label();
    }

    public void addWayPoint(FXEdgeWayPoint aWayPoint) {
        this.wayPoints.add(aWayPoint);
        this.graph.updateEdge(this, this.graph.zoomHandler.currentZoomLevel);
    }

    public void removeWayPoint(FXEdgeWayPoint aWayPoint) {
        this.wayPoints.remove(aWayPoint);
        this.graph.updateEdge(this, this.graph.zoomHandler.currentZoomLevel);
    }

    public Node compileDisplayShapeFor(FXEdgeWayPoint aWayPoint, double aZoomLevel) {
        RectangleBuilder theBuilder = RectangleBuilder.create();
        theBuilder.width(4.0).height(4.0).fill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_edge", "#007c8f"))).stroke((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_edge", "#007c8f")));
        Rectangle theNode = theBuilder.build();
        theNode.setScaleX(aZoomLevel);
        theNode.setScaleY(aZoomLevel);
        this.lblWeight.setScaleX(aZoomLevel);
        this.lblWeight.setScaleY(aZoomLevel);
        theNode.setLayoutX((aWayPoint.positionX - 2.0) * aZoomLevel);
        theNode.setLayoutY((aWayPoint.positionY - 2.0) * aZoomLevel);
        theNode.setUserData((Object)aWayPoint);
        return theNode;
    }

    public void computeDisplayShape(double aCurrentZoomLevel) {
        Path thePath = new Path();
        thePath.setUserData((Object)this);
        Bounds theSourceBounds = this.source.wrappedNode.getBoundsInParent();
        double startX = theSourceBounds.getMinX() + theSourceBounds.getWidth() / 2.0;
        double startY = theSourceBounds.getMinY() + theSourceBounds.getHeight() / 2.0;
        this.wayPointHandles.clear();
        for (FXEdgeWayPoint theWayPoint : this.wayPoints) {
            this.wayPointHandles.put(theWayPoint, this.compileDisplayShapeFor(theWayPoint, aCurrentZoomLevel));
        }
        Bounds theDestinationBounds = this.destination.wrappedNode.getBoundsInParent();
        double endX = theDestinationBounds.getMinX() + theDestinationBounds.getWidth() / 2.0;
        double endY = theDestinationBounds.getMinY() + theDestinationBounds.getHeight() / 2.0;
        this.positionMiddleLineX = (theSourceBounds.getMinX() + theSourceBounds.getWidth() / 2.0 + (theDestinationBounds.getMinX() + theDestinationBounds.getWidth() / 2.0)) / 2.0;
        this.positionMiddleLineY = (theSourceBounds.getMinY() + theSourceBounds.getHeight() / 2.0 + (theDestinationBounds.getMinY() + theDestinationBounds.getHeight() / 2.0)) / 2.0;
        this.endArrowX = (this.positionMiddleLineX + endX) / 2.0;
        this.endArrowY = (this.positionMiddleLineY + endY) / 2.0;
        this.lblWeight.setScaleX(aCurrentZoomLevel);
        this.lblWeight.setScaleY(aCurrentZoomLevel);
        double arrowHeadSize = this.isOriented() ? 10.0 : 0.0;
        FXArrow arrow = new FXArrow(startX, startY, endX, endY, this.endArrowX, this.endArrowY, arrowHeadSize);
        this.displayShape = arrow;
    }

    public boolean isOriented() {
        return this.oriented;
    }

    public void setOriented(boolean oriented) {
        this.oriented = oriented;
    }

    public void removeAllNodes(Pane aPane) {
        aPane.getChildren().remove((Object)this.displayShape);
        aPane.getChildren().remove((Object)this.lblWeight);
        aPane.getChildren().removeAll(this.wayPointHandles.values());
    }

    public void addAllNodes(Pane aPane, double aZIndex) {
        aPane.getChildren().add((Object)this.displayShape);
        if (this.isOriented()) {
            this.lblWeight.setTranslateX(this.endArrowX);
            this.lblWeight.setTranslateY(this.endArrowY);
        } else {
            this.lblWeight.setTranslateX(this.positionMiddleLineX);
            this.lblWeight.setTranslateY(this.positionMiddleLineY);
        }
        this.lblWeight.setStyle("-fx-font-size: 15px");
        this.lblWeight.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_weight", Utils.toRGBCode(Color.BLACK))));
        aPane.getChildren().add((Object)this.lblWeight);
        this.displayShape.setTranslateZ(aZIndex);
        this.displayShape.toBack();
        for (Node theNode : this.wayPointHandles.values()) {
            theNode.setTranslateZ(aZIndex);
            aPane.getChildren().add((Object)theNode);
            theNode.toBack();
        }
    }

    public double getWeight() {
        return this.weight;
    }

    public void setEdgeColor(String hexColor) {
        ((Path)this.displayShape).setFill((Paint)Color.web((String)hexColor));
    }

    public void setWeightTextColor(String hexColor) {
        this.lblWeight.setTextFill((Paint)Color.web((String)hexColor));
    }

    public void setWeight(double weight) {
        this.weight = weight;
        this.lblWeight.setText(String.valueOf(weight));
    }

    public FXNode getSource() {
        return this.source;
    }

    public void setSource(FXNode source) {
        this.source = source;
    }

    public FXNode getDestination() {
        return this.destination;
    }

    public void setDestination(FXNode destination) {
        this.destination = destination;
    }

    public Node getDisplayShape() {
        return this.displayShape;
    }

    public String toString() {
        return "FXEdge{source=" + this.source + ", destination=" + this.destination + ", weight=" + this.weight + '}';
    }
}

