/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXEdge;
import fxgraph.FXGraphKeyboardHandler;
import fxgraph.FXGraphModel;
import fxgraph.FXGraphMouseHandler;
import fxgraph.FXGraphSelectionTool;
import fxgraph.FXGraphZoomHandler;
import fxgraph.FXNode;
import fxgraph.FXNodeGeneric;
import fxgraph.FXTool;
import fxgraph.OnRemoveSelection;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;

public class FXGraph
extends ScrollPane
implements OnRemoveSelection {
    static final double NODES_Z_OFFSET = 10.0;
    static final double EDGES_Z_OFFSET = 10.0;
    private OnRemoveSelection onRemoveSelection = null;
    Pane contentPane;
    FXGraphModel model = new FXGraphModel();
    FXGraphSelectionTool selectionTool;
    FXGraphZoomHandler zoomHandler;
    FXTool currentTool;
    private FXGraphMouseHandler mouseHandler;
    private FXGraphKeyboardHandler keyboardHandler;

    public FXGraph() {
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.contentPane = new Pane();
        this.setContent((Node)this.contentPane);
        this.zoomHandler = new FXGraphZoomHandler(this);
        this.selectionTool = new FXGraphSelectionTool(this.contentPane, this.model, this.zoomHandler);
        this.mouseHandler = new FXGraphMouseHandler(this);
        this.keyboardHandler = new FXGraphKeyboardHandler(this);
        this.mouseHandler.registerHandlerFor((Node)this.contentPane);
        this.currentTool = this.selectionTool;
        this.contentPane.setStyle("-fx-background-color: white;");
        this.setOnMouseEntered(event -> this.requestFocus());
    }

    public FXGraphSelectionTool getFxGraphSelectionTool() {
        return this.selectionTool;
    }

    public void setOnRemoveSelection(OnRemoveSelection onRemoveSelection) {
        this.onRemoveSelection = onRemoveSelection;
    }

    public void setSizeGraph(double width, double height) {
        this.contentPane.setPrefWidth(width);
        this.contentPane.setPrefHeight(height);
    }

    void updateEdge(FXEdge aEdge, double aZoomLevel) {
        aEdge.removeAllNodes(this.contentPane);
        aEdge.computeDisplayShape(aZoomLevel);
        aEdge.addAllNodes(this.contentPane, 10.0);
        this.mouseHandler.registerNewEdge(aEdge);
    }

    void updateEdgeNodesFor(FXNode aNode, double aZoomLevel) {
        for (FXEdge theEdge : this.model.getEdges()) {
            if (theEdge.source != aNode && theEdge.destination != aNode) continue;
            this.updateEdge(theEdge, aZoomLevel);
        }
    }

    public void removeEdge(FXEdge fxEdge) {
        this.model.removeEdge(fxEdge);
    }

    public void removeNode(FXNodeGeneric fxNodeGeneric) {
        this.model.removeNode(fxNodeGeneric);
    }

    public void removeEdges(Set<FXEdge> fxEdgeSet) {
        for (FXEdge fxEdge : fxEdgeSet) {
            fxEdge.removeAllNodes(this.contentPane);
            this.removeEdge(fxEdge);
        }
    }

    void updateEdgeNodesFor(FXNode aNode) {
        this.updateEdgeNodesFor(aNode, this.zoomHandler.currentZoomLevel);
    }

    public void updateSelectionInScene() {
        this.selectionTool.updateSelectionInScene();
    }

    public void addNode(FXNode aNode) {
        aNode.wrappedNode.setTranslateZ(10.0);
        aNode.setZoomLevel(this.zoomHandler.currentZoomLevel);
        this.contentPane.getChildren().add((Object)aNode.wrappedNode);
        this.model.registerNewNode(aNode);
        this.mouseHandler.registerNewNode(aNode);
    }

    public void addEdge(FXEdge aEdge) {
        aEdge.computeDisplayShape(this.zoomHandler.currentZoomLevel);
        aEdge.addAllNodes(this.contentPane, 10.0);
        this.model.registerNewEdge(aEdge);
        this.mouseHandler.registerNewEdge(aEdge);
    }

    public FXGraphModel getModel() {
        return this.model;
    }

    public void setModel(FXGraphModel model) {
        this.model = model;
    }

    public FXGraphZoomHandler getZoomHandler() {
        return this.zoomHandler;
    }

    public Pane getContentPane() {
        return this.contentPane;
    }

    @Override
    public void onRemoveMultipleNode() {
        if (this.onRemoveSelection != null) {
            this.onRemoveSelection.onRemoveMultipleNode();
        }
    }
}

