/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXEdge;
import fxgraph.FXEdgeWayPoint;
import fxgraph.FXGraphModel;
import fxgraph.FXGraphZoomHandler;
import fxgraph.FXNode;
import fxgraph.FXTool;
import java.util.HashSet;
import java.util.Set;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TimelineBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.util.Duration;

public class FXGraphSelectionTool
extends FXTool {
    static final double SELECTION_Z_OFFSET = 20.0;
    private Pane owningControl;
    private FXGraphModel model;
    private FXGraphZoomHandler zoomHandler;
    private Set<FXNode> currentSelection;
    private Rectangle currentSelectionRectangle;
    private Timeline currentSelectionTimeline;
    private Rectangle interactiveSelectionRectangle;
    private Timeline interactiveSelectionTimeline;
    private boolean dragging;
    private double lastDragX;
    private double lastDragY;
    private boolean mousePressedOnNodeOrSelection;
    private FXEdgeWayPoint pressedWaypoint;

    FXGraphSelectionTool(Pane aOwningControl, FXGraphModel aModel, FXGraphZoomHandler aZoomHandler) {
        this.owningControl = aOwningControl;
        this.model = aModel;
        this.zoomHandler = aZoomHandler;
        this.currentSelection = new HashSet<FXNode>();
    }

    public void resetSelection() {
        this.currentSelection.clear();
        for (FXNode fxNode : this.model.getNodes()) {
            fxNode.onDeselect();
        }
    }

    public void add(FXNode aNode) {
        this.currentSelection.add(aNode);
        aNode.onSelect();
    }

    public void updateSelectionInScene() {
        if (this.currentSelectionRectangle != null) {
            this.owningControl.getChildren().remove((Object)this.currentSelectionRectangle);
            this.currentSelectionTimeline.stop();
        }
        if (this.currentSelection.size() > 0) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double maxY = Double.MIN_VALUE;
            for (FXNode theNode : this.currentSelection) {
                Bounds theBounds = theNode.wrappedNode.getBoundsInParent();
                minX = Math.min(minX, theBounds.getMinX());
                minY = Math.min(minY, theBounds.getMinY());
                maxX = Math.max(maxX, theBounds.getMaxX());
                maxY = Math.max(maxY, theBounds.getMaxY());
            }
            double startX = minX - 20.0;
            double startY = minY - 20.0;
            double width = maxX - minX + 40.0;
            double height = maxY - minY + 40.0;
            RectangleBuilder theBuilder = RectangleBuilder.create();
            theBuilder.x(startX).y(startY).width(width).height(height).strokeWidth(1.0).stroke((Paint)Color.GRAY).strokeDashArray(new Double[]{3.0, 7.0, 3.0, 7.0}).fill((Paint)Color.TRANSPARENT).mouseTransparent(true);
            this.currentSelectionRectangle = theBuilder.build();
            this.currentSelectionRectangle.setTranslateZ(20.0);
            this.owningControl.getChildren().add((Object)this.currentSelectionRectangle);
            Duration theDuration = Duration.millis((double)40.0);
            KeyFrame theOneFrame = new KeyFrame(theDuration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    FXGraphSelectionTool.this.currentSelectionRectangle.setStrokeDashOffset(FXGraphSelectionTool.this.currentSelectionRectangle.getStrokeDashOffset() + 1.0);
                }
            }, new KeyValue[0]);
            this.currentSelectionTimeline = ((TimelineBuilder)TimelineBuilder.create().cycleCount(-1)).keyFrames(new KeyFrame[]{theOneFrame}).build();
            this.currentSelectionTimeline.play();
        }
    }

    public Set<FXNode> getCurrentSelection() {
        return this.currentSelection;
    }

    public Rectangle getCurrentSelectionRectangle() {
        return this.currentSelectionRectangle;
    }

    public boolean contains(FXNode aNode) {
        return this.currentSelection.contains(aNode);
    }

    public void remove(FXNode aNode) {
        this.currentSelection.remove(aNode);
        aNode.onDeselect();
    }

    public boolean isSelectionMode() {
        return this.interactiveSelectionRectangle != null;
    }

    public void startSelectionAt(double aSceneX, double aSceneY) {
        RectangleBuilder theBuilder = RectangleBuilder.create();
        theBuilder.x(aSceneX).y(aSceneY).width(1.0).height(1.0).strokeWidth(1.0).stroke((Paint)Color.BLACK).strokeDashArray(new Double[]{3.0, 7.0, 3.0, 7.0}).fill((Paint)Color.TRANSPARENT).mouseTransparent(true);
        this.interactiveSelectionRectangle = theBuilder.build();
        this.interactiveSelectionRectangle.setTranslateZ(20.0);
        this.owningControl.getChildren().add((Object)this.interactiveSelectionRectangle);
        Duration theDuration = Duration.millis((double)40.0);
        KeyFrame theOneFrame = new KeyFrame(theDuration, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXGraphSelectionTool.this.interactiveSelectionRectangle.setStrokeDashOffset(FXGraphSelectionTool.this.interactiveSelectionRectangle.getStrokeDashOffset() + 1.0);
            }
        }, new KeyValue[0]);
        this.interactiveSelectionTimeline = ((TimelineBuilder)TimelineBuilder.create().cycleCount(-1)).keyFrames(new KeyFrame[]{theOneFrame}).build();
        this.interactiveSelectionTimeline.play();
    }

    public void enhanceSelectionTo(double aSceneX, double aSceneY) {
        double width = aSceneX - this.interactiveSelectionRectangle.getX();
        double height = aSceneY - this.interactiveSelectionRectangle.getY();
        this.interactiveSelectionRectangle.setWidth(width);
        this.interactiveSelectionRectangle.setHeight(height);
    }

    public void endSelection() {
        for (FXNode theNode : this.model.getNodes()) {
            if (!this.interactiveSelectionRectangle.intersects(theNode.wrappedNode.getBoundsInParent())) continue;
            this.add(theNode);
        }
        this.interactiveSelectionTimeline.stop();
        this.interactiveSelectionTimeline = null;
        this.owningControl.getChildren().remove((Object)this.interactiveSelectionRectangle);
        this.interactiveSelectionRectangle = null;
        this.updateSelectionInScene();
    }

    @Override
    public void mousePressedOnNode(MouseEvent aEvent, FXNode aNode) {
        this.mousePressedOnNodeOrSelection = true;
        this.pressedWaypoint = null;
        if (aEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.owningControl.setCursor(Cursor.MOVE);
            this.resetSelection();
            this.currentSelection.addAll(this.model.getNodes());
            this.mousePressedOnNodeOrSelection = true;
            this.updateSelectionInScene();
        } else if (!aEvent.isControlDown() && !aEvent.isShiftDown()) {
            this.resetSelection();
            this.add(aNode);
        } else if (this.contains(aNode)) {
            this.remove(aNode);
        } else {
            this.add(aNode);
        }
        this.updateSelectionInScene();
    }

    @Override
    public void mousePressedOnEdge(MouseEvent aEvent, FXEdge aEdge) {
        this.mousePressedOnNodeOrSelection = true;
        this.pressedWaypoint = null;
        this.resetSelection();
        this.updateSelectionInScene();
    }

    @Override
    public void mousePressedOnEdgeWayPoint(MouseEvent aEvent, FXEdgeWayPoint aWayPoint) {
        this.mousePressedOnNodeOrSelection = false;
        this.pressedWaypoint = aWayPoint;
    }

    @Override
    public void mousePressed(MouseEvent aEvent) {
        this.mousePressedOnNodeOrSelection = false;
        this.pressedWaypoint = null;
        Rectangle theSelection = this.getCurrentSelectionRectangle();
        if (theSelection != null) {
            if (theSelection.contains(aEvent.getX(), aEvent.getY())) {
                this.mousePressedOnNodeOrSelection = true;
            } else {
                this.resetSelection();
                this.updateSelectionInScene();
            }
        }
        if (aEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.owningControl.setCursor(Cursor.MOVE);
            this.resetSelection();
            this.currentSelection.addAll(this.model.getNodes());
            this.mousePressedOnNodeOrSelection = true;
            this.updateSelectionInScene();
        }
    }

    @Override
    public void mouseDragged(MouseEvent aEvent) {
        if (this.mousePressedOnNodeOrSelection || this.pressedWaypoint != null) {
            if (!this.dragging) {
                this.dragging = true;
            } else {
                double movementX = aEvent.getSceneX() - this.lastDragX;
                double movementY = aEvent.getSceneY() - this.lastDragY;
                if (this.pressedWaypoint == null) {
                    for (FXNode theNode : this.getCurrentSelection()) {
                        theNode.translatePosition(movementX, movementY, this.zoomHandler.currentZoomLevel);
                    }
                } else {
                    this.pressedWaypoint.translatePosition(movementX / this.zoomHandler.currentZoomLevel, movementY / this.zoomHandler.currentZoomLevel, this.zoomHandler.currentZoomLevel);
                }
                this.updateSelectionInScene();
            }
            this.lastDragX = aEvent.getSceneX();
            this.lastDragY = aEvent.getSceneY();
        } else if (!this.isSelectionMode()) {
            if (!aEvent.isShiftDown() && !aEvent.isControlDown()) {
                this.resetSelection();
            }
            this.startSelectionAt(aEvent.getX(), aEvent.getY());
        } else {
            this.enhanceSelectionTo(aEvent.getX(), aEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent aEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.updateSelectionInScene();
        }
        if (this.isSelectionMode()) {
            this.endSelection();
        }
        if (aEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.resetSelection();
            this.updateSelectionInScene();
        }
        this.owningControl.setCursor(Cursor.DEFAULT);
    }
}

