/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.games.AlphaBeta;
import aima.games.GameState;
import aima.util.Util;
import java.util.ArrayList;

public abstract class Game {
    protected GameState initialState = new GameState();
    protected GameState presentState = new GameState();
    protected int level;

    public int getLevel(GameState g) {
        return (Integer)g.get("level");
    }

    public ArrayList getMoves(GameState state) {
        return (ArrayList)state.get("moves");
    }

    public String getPlayerToMove(GameState state) {
        return (String)state.get("player");
    }

    public int getUtility(GameState h) {
        return (Integer)h.get("utility");
    }

    public GameState getState() {
        return this.presentState;
    }

    protected abstract int computeUtility(GameState var1);

    protected abstract boolean terminalTest(GameState var1);

    public int maxValue(GameState state) {
        int v = Integer.MIN_VALUE;
        if (this.terminalTest(state)) {
            return this.computeUtility(state);
        }
        ArrayList successorList = this.getSuccessorStates(state);
        for (int i = 0; i < successorList.size(); ++i) {
            GameState successor = (GameState)successorList.get(i);
            int minimumValueOfSuccessor = this.minValue(successor);
            if (minimumValueOfSuccessor <= v) continue;
            v = minimumValueOfSuccessor;
            state.put("next", successor);
        }
        return v;
    }

    public int minValue(GameState state) {
        int v = Integer.MAX_VALUE;
        if (this.terminalTest(state)) {
            return this.computeUtility(state);
        }
        ArrayList successorList = this.getSuccessorStates(state);
        for (int i = 0; i < successorList.size(); ++i) {
            GameState successor = (GameState)successorList.get(i);
            int maximumValueOfSuccessors = this.maxValue(successor);
            if (maximumValueOfSuccessors >= v) continue;
            v = maximumValueOfSuccessors;
            state.put("next", successor);
        }
        return v;
    }

    protected int maxValue(GameState state, AlphaBeta ab) {
        int v = Integer.MIN_VALUE;
        if (this.terminalTest(state)) {
            return this.computeUtility(state);
        }
        ArrayList successorList = this.getSuccessorStates(state);
        for (int i = 0; i < successorList.size(); ++i) {
            GameState successor = (GameState)successorList.get(i);
            int minimumValueOfSuccessor = this.minValue(successor, ab.copy());
            if (minimumValueOfSuccessor > v) {
                v = minimumValueOfSuccessor;
                state.put("next", successor);
            }
            if (v >= ab.beta()) {
                return v;
            }
            ab.setAlpha(Util.max(ab.alpha(), v));
        }
        return v;
    }

    public int minValue(GameState state, AlphaBeta ab) {
        int v = Integer.MAX_VALUE;
        if (this.terminalTest(state)) {
            return this.computeUtility(state);
        }
        ArrayList successorList = this.getSuccessorStates(state);
        for (int i = 0; i < successorList.size(); ++i) {
            GameState successor = (GameState)successorList.get(i);
            int maximumValueOfSuccessor = this.maxValue(successor, ab.copy());
            if (maximumValueOfSuccessor < v) {
                v = maximumValueOfSuccessor;
                state.put("next", successor);
            }
            if (v <= ab.alpha()) {
                return v;
            }
            ab.setBeta(Util.min(ab.beta(), v));
        }
        return v;
    }

    public void makeMiniMaxMove() {
        this.getMiniMaxValue(this.presentState);
        GameState nextState = (GameState)this.presentState.get("next");
        if (nextState == null) {
            throw new RuntimeException("Mini Max Move failed");
        }
        this.makeMove(this.presentState, nextState.get("moveMade"));
    }

    public void makeAlphaBetaMove() {
        this.getAlphaBetaValue(this.presentState);
        GameState nextState = (GameState)this.presentState.get("next");
        if (nextState == null) {
            throw new RuntimeException("Alpha Beta Move failed");
        }
        this.makeMove(this.presentState, nextState.get("moveMade"));
    }

    public abstract ArrayList getSuccessorStates(GameState var1);

    public abstract GameState makeMove(GameState var1, Object var2);

    public boolean hasEnded() {
        return this.terminalTest(this.getState());
    }

    public abstract int getMiniMaxValue(GameState var1);

    public abstract int getAlphaBetaValue(GameState var1);
}

