/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.framework;

import aima.gui.framework.AgentAppModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;

public class AgentAppFrame
extends JFrame
implements AgentAppModel.ModelChangedListener {
    protected Controller controller;
    private AgentAppModel model;
    private int updateDelay;
    protected AgentThread agentThread;
    protected boolean isPrepared;
    private SelectorContainer selectors;
    private JToolBar toolbar;
    private JButton clearButton;
    private JButton prepareButton;
    private JButton runButton;
    private JButton cancelButton;
    JSplitPane centerPane;
    protected JTextArea textArea;
    protected AbstractAgentView agentView;
    private JLabel statusLabel;

    public AgentAppFrame() {
        this.initComponents();
        this.pack();
        System.setOut(new PrintStream(new TextAreaOutputStream()));
        this.updateDelay = 0;
        this.setButtonsEnabled(true);
    }

    public void setSelectors(String[] selectorNames, String[] tooltips) {
        Controller cont = this.controller;
        this.controller = null;
        this.selectors.setSelectors(selectorNames, tooltips);
        this.controller = cont;
    }

    public void setSelectorItems(String selectorName, String[] items, int defaultIdx) {
        Controller cont = this.controller;
        this.controller = null;
        this.selectors.setSelectorItems(selectorName, items, defaultIdx);
        this.controller = cont;
    }

    public void setDefaultSelection() {
        Controller cont = this.controller;
        this.controller = null;
        this.selectors.setDefaults();
        if (cont != null) {
            this.controller = cont;
            this.selectionChanged();
        }
    }

    public SelectionState getSelection() {
        return this.selectors.getSelection();
    }

    public void setAgentView(AbstractAgentView view) {
        this.agentView = view;
        this.centerPane.add("left", this.agentView);
    }

    public void setSplitPaneResizeWeight(double value) {
        this.centerPane.setResizeWeight(value);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setModel(AgentAppModel model) {
        this.model = model;
        this.agentView.updateView(model);
    }

    public void setUpdateDelay(int msec) {
        this.updateDelay = msec;
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    @Override
    public void modelChanged() {
        this.agentView.updateView(this.model);
        try {
            Thread.sleep(this.updateDelay);
        }
        catch (Exception e) {
            this.logMessage("Error: Something went wrong when updating the view after a model change (" + e + ").");
            e.printStackTrace();
        }
    }

    @Override
    public void logMessage(String message) {
        MessageLogger ml = new MessageLogger();
        ml.message = message;
        if (SwingUtilities.isEventDispatchThread()) {
            ml.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(ml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.toolbar = new JToolBar();
        this.selectors = new SelectorContainer();
        this.toolbar.add(Box.createHorizontalGlue());
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Clear Views");
        this.clearButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.clearButton);
        this.prepareButton = new JButton("Prepare");
        this.prepareButton.setToolTipText("Prepare Agent");
        this.prepareButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.prepareButton);
        this.runButton = new JButton("Run");
        this.runButton.setToolTipText("Run Agent");
        this.runButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.runButton);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane scrollTPane = new JScrollPane(this.textArea);
        this.agentView = new AbstractAgentView(){

            @Override
            public void updateView(AgentAppModel model) {
            }
        };
        JScrollPane scrollGPane = new JScrollPane(this.agentView);
        this.centerPane = new JSplitPane(1);
        this.centerPane.add("left", scrollGPane);
        this.centerPane.add("right", scrollTPane);
        this.centerPane.setDividerSize(5);
        this.centerPane.setResizeWeight(0.8);
        this.getContentPane().add((Component)this.centerPane, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("");
        this.statusLabel.setBorder(new EtchedBorder());
        statusPanel.add((Component)this.statusLabel, "Center");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel Agent");
        this.cancelButton.addActionListener(new FrameActionListener());
        this.cancelButton.setPreferredSize(new Dimension(80, 20));
        this.cancelButton.setBorder(new EtchedBorder());
        statusPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)statusPanel, "South");
    }

    private void setButtonsEnabled(boolean b) {
        this.clearButton.setEnabled(b);
        this.prepareButton.setEnabled(b);
        this.runButton.setEnabled(b);
        this.cancelButton.setEnabled(!b);
        for (JComboBox combo : this.selectors.combos) {
            combo.setEnabled(b);
        }
    }

    protected void selectionChanged() {
        if (this.controller != null) {
            this.controller.prepareAgent();
            this.isPrepared = true;
        }
    }

    public static void main(String[] args) {
        AgentAppFrame frame = new AgentAppFrame();
        frame.setVisible(true);
    }

    public static interface Controller {
        public void clearAgent();

        public void prepareAgent();

        public void runAgent();
    }

    public static abstract class AbstractAgentView
    extends JPanel {
        public abstract void updateView(AgentAppModel var1);
    }

    public static class SelectionState {
        private final List<String> selectors = new ArrayList<String>();
        private final List<Integer> selIndices = new ArrayList<Integer>();

        protected SelectionState(String[] selectors) {
            for (String sel : selectors) {
                this.selectors.add(sel);
                this.selIndices.add(null);
            }
        }

        public int size() {
            return this.selectors.size();
        }

        void setValue(int selectorIdx, int valIdx) {
            this.selIndices.set(selectorIdx, valIdx);
        }

        void setValue(String selector, int valIdx) {
            this.selIndices.set(this.selectors.indexOf(selector), valIdx);
        }

        public int getValue(int selectorIdx) {
            return this.selIndices.get(selectorIdx);
        }

        public int getValue(String selector) {
            return this.selIndices.get(this.selectors.indexOf(selector));
        }

        public String toString() {
            StringBuffer result = new StringBuffer("State[ ");
            for (int i = 0; i < this.size(); ++i) {
                result.append(this.selectors.get(i) + "=" + this.selIndices.get(i) + " ");
            }
            result.append("]");
            return result.toString();
        }
    }

    private class SelectorContainer {
        String[] selectorNames = new String[0];
        int[] selectorDefaults = new int[0];
        List<JComboBox> combos = new ArrayList<JComboBox>();

        private SelectorContainer() {
        }

        public void setSelectors(String[] selectorNames, String[] tooltips) {
            this.selectorNames = selectorNames;
            this.selectorDefaults = new int[selectorNames.length];
            for (JComboBox jComboBox : this.combos) {
                AgentAppFrame.this.toolbar.remove(jComboBox);
            }
            this.combos.clear();
            for (int i = 0; i < selectorNames.length; ++i) {
                JComboBox jComboBox = new JComboBox();
                jComboBox.addActionListener(new FrameActionListener());
                this.combos.add(jComboBox);
                AgentAppFrame.this.toolbar.add((Component)jComboBox, i);
                if (tooltips == null) continue;
                jComboBox.setToolTipText(tooltips[i]);
            }
        }

        public void setSelectorItems(String selectorName, String[] items, int defaultIdx) {
            JComboBox combo = this.getCombo(selectorName);
            combo.removeAllItems();
            for (String item : items) {
                combo.addItem(item);
            }
            this.selectorDefaults[this.combos.indexOf((Object)combo)] = defaultIdx;
        }

        public void setDefaults() {
            for (int i = 0; i < this.selectorDefaults.length; ++i) {
                if (this.combos.get(i).getItemCount() <= 0) continue;
                this.combos.get(i).setSelectedIndex(this.selectorDefaults[i]);
            }
        }

        public SelectionState getSelection() {
            SelectionState result = new SelectionState(this.selectorNames);
            for (int i = 0; i < result.size(); ++i) {
                result.setValue(i, this.combos.get(i).getSelectedIndex());
            }
            return result;
        }

        JComboBox getCombo(String selectorName) {
            for (int i = 0; i < this.selectorNames.length; ++i) {
                if (!this.selectorNames[i].equals(selectorName)) continue;
                return this.combos.get(i);
            }
            return null;
        }
    }

    private class TextAreaOutputStream
    extends OutputStream {
        private TextAreaOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            String s = new String(new char[]{(char)b});
            AgentAppFrame.this.textArea.append(s);
        }
    }

    private class AgentThread
    extends Thread {
        private AgentThread() {
        }

        @Override
        public void run() {
            AgentAppFrame.this.agentThread = this;
            try {
                AgentAppFrame.this.controller.runAgent();
            }
            catch (Exception e) {
                AgentAppFrame.this.logMessage("Error: Somthing went wrong running the agent (" + e + ").");
                e.printStackTrace();
            }
            AgentAppFrame.this.setButtonsEnabled(true);
            AgentAppFrame.this.agentThread = null;
        }
    }

    private class FrameActionListener
    implements ActionListener {
        private FrameActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String text = "";
            try {
                if (AgentAppFrame.this.controller != null) {
                    AgentAppFrame.this.setStatus("");
                    Object source = evt.getSource();
                    if (source == AgentAppFrame.this.clearButton) {
                        text = "when clearing the views ";
                        Document doc = AgentAppFrame.this.textArea.getDocument();
                        doc.remove(0, doc.getLength());
                        AgentAppFrame.this.statusLabel.setText("");
                        AgentAppFrame.this.controller.clearAgent();
                    } else if (source == AgentAppFrame.this.prepareButton) {
                        text = "when preparing the agent ";
                        AgentAppFrame.this.controller.prepareAgent();
                        AgentAppFrame.this.isPrepared = true;
                    } else if (source == AgentAppFrame.this.runButton) {
                        text = "when preparing the agent ";
                        if (!AgentAppFrame.this.isPrepared) {
                            AgentAppFrame.this.controller.prepareAgent();
                        }
                        text = "when running the agent ";
                        AgentAppFrame.this.setButtonsEnabled(false);
                        AgentAppFrame.this.agentThread = new AgentThread();
                        AgentAppFrame.this.agentThread.start();
                        AgentAppFrame.this.isPrepared = false;
                    } else if (source == AgentAppFrame.this.cancelButton) {
                        text = "when cancelling the agent ";
                        if (AgentAppFrame.this.agentThread != null) {
                            AgentAppFrame.this.agentThread.stop();
                            AgentAppFrame.this.agentThread = null;
                            AgentAppFrame.this.setStatus("Task cancelled.");
                            AgentAppFrame.this.setButtonsEnabled(true);
                        }
                        AgentAppFrame.this.isPrepared = false;
                    } else if (((AgentAppFrame)AgentAppFrame.this).selectors.combos.contains(source)) {
                        text = "when preparing the agent ";
                        AgentAppFrame.this.selectionChanged();
                    }
                }
            }
            catch (Exception e) {
                AgentAppFrame.this.logMessage("Error: Something went wrong " + text + "(" + e + ").");
                e.printStackTrace();
            }
        }
    }

    private class MessageLogger
    implements Runnable {
        String message;

        private MessageLogger() {
        }

        @Override
        public void run() {
            int start = AgentAppFrame.this.textArea.getDocument().getLength();
            AgentAppFrame.this.textArea.append(this.message + "\n");
            int end = AgentAppFrame.this.textArea.getDocument().getLength();
            AgentAppFrame.this.textArea.setSelectionStart(start);
            AgentAppFrame.this.textArea.setSelectionEnd(end);
        }
    }
}

