/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.Attribute;
import aima.learning.framework.NumericAttribute;
import aima.learning.framework.NumericAttributeSpecification;
import aima.learning.framework.StringAttribute;
import java.util.Hashtable;

public class Example {
    Hashtable<String, Attribute> attributes;
    private Attribute targetAttribute;

    public Example(Hashtable<String, Attribute> attributes, Attribute targetAttribute) {
        this.attributes = attributes;
        this.targetAttribute = targetAttribute;
    }

    public String getAttributeValueAsString(String attributeName) {
        return this.attributes.get(attributeName).valueAsString();
    }

    public double getAttributeValueAsDouble(String attributeName) {
        Attribute attribute = this.attributes.get(attributeName);
        if (attribute == null || !(attribute instanceof NumericAttribute)) {
            throw new RuntimeException("cannot return numerical value for non numeric attribute");
        }
        return ((NumericAttribute)attribute).valueAsDouble();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public String targetValue() {
        return this.getAttributeValueAsString(this.targetAttribute.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Example other = (Example)o;
        return this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public Example numerize(Hashtable<String, Hashtable<String, Integer>> attrValueToNumber) {
        Hashtable<String, Attribute> numerizedExampleData = new Hashtable<String, Attribute>();
        for (String key : this.attributes.keySet()) {
            Attribute attribute = this.attributes.get(key);
            if (attribute instanceof StringAttribute) {
                int correspondingNumber = attrValueToNumber.get(key).get(attribute.valueAsString());
                NumericAttributeSpecification spec = new NumericAttributeSpecification(key);
                numerizedExampleData.put(key, new NumericAttribute(correspondingNumber, spec));
                continue;
            }
            numerizedExampleData.put(key, attribute);
        }
        return new Example(numerizedExampleData, (Attribute)numerizedExampleData.get(this.targetAttribute.name()));
    }
}

