/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TermEquality
implements AtomicSentence {
    private Term term1;
    private Term term2;
    private List<Term> terms = new ArrayList<Term>();
    private String stringRep = null;
    private int hashCode = 0;

    public static String getEqualitySynbol() {
        return "=";
    }

    public TermEquality(Term term1, Term term2) {
        this.term1 = term1;
        this.term2 = term2;
        this.terms.add(term1);
        this.terms.add(term2);
    }

    public Term getTerm1() {
        return this.term1;
    }

    public Term getTerm2() {
        return this.term2;
    }

    @Override
    public String getSymbolicName() {
        return TermEquality.getEqualitySynbol();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public List<Term> getArgs() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitTermEquality(this, arg);
    }

    @Override
    public TermEquality copy() {
        return new TermEquality(this.term1.copy(), this.term2.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermEquality te = (TermEquality)o;
        return te.getTerm1().equals(this.term1) && te.getTerm2().equals(this.term2);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getTerm1().hashCode();
            this.hashCode = 37 * this.hashCode + this.getTerm2().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.term1.toString());
            sb.append(" = ");
            sb.append(this.term2.toString());
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

