/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import java.util.ArrayList;
import java.util.List;

public class AbstractPLVisitor
implements PLVisitor {
    private PEParser parser = new PEParser();

    @Override
    public Object visitSymbol(Symbol s, Object arg) {
        return new Symbol(s.getValue());
    }

    @Override
    public Object visitTrueSentence(TrueSentence ts, Object arg) {
        return new TrueSentence();
    }

    @Override
    public Object visitFalseSentence(FalseSentence fs, Object arg) {
        return new FalseSentence();
    }

    @Override
    public Object visitNotSentence(UnarySentence fs, Object arg) {
        return new UnarySentence((Sentence)fs.getNegated().accept(this, arg));
    }

    @Override
    public Object visitBinarySentence(BinarySentence fs, Object arg) {
        return new BinarySentence(fs.getOperator(), (Sentence)fs.getFirst().accept(this, arg), (Sentence)fs.getSecond().accept(this, arg));
    }

    @Override
    public Object visitMultiSentence(MultiSentence fs, Object arg) {
        List terms = fs.getSentences();
        ArrayList<Sentence> newTerms = new ArrayList<Sentence>();
        for (int i = 0; i < terms.size(); ++i) {
            Sentence s = (Sentence)terms.get(i);
            Sentence subsTerm = (Sentence)s.accept(this, arg);
            newTerms.add(subsTerm);
        }
        return new MultiSentence(fs.getOperator(), newTerms);
    }

    protected Sentence recreate(Object ast) {
        return (Sentence)this.parser.parse(((Sentence)ast).toString());
    }
}

