/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.util.Matrix;
import java.util.ArrayList;

public class FixedLagSmoothing {
    private HiddenMarkovModel hmm;
    private int timelag;
    private ArrayList<String> evidenceFromSmoothedStepToPresent;
    private int time;
    private RandomVariable forwardMessage;
    private Matrix B;

    public FixedLagSmoothing(HiddenMarkovModel hmm, int timelag) {
        this.hmm = hmm;
        this.timelag = timelag;
        this.evidenceFromSmoothedStepToPresent = new ArrayList();
        this.time = 1;
        this.forwardMessage = hmm.prior();
        this.B = hmm.transitionModel().unitMatrix();
    }

    public RandomVariable smooth(String perception) {
        this.evidenceFromSmoothedStepToPresent.add(perception);
        Matrix O_t = this.hmm.sensorModel().asMatrix(perception);
        Matrix transitionMatrix = this.hmm.transitionModel().asMatrix();
        if (this.time > this.timelag) {
            this.forwardMessage = this.hmm.forward(this.forwardMessage, perception);
            this.evidenceFromSmoothedStepToPresent.remove(0);
            Matrix O_t_minus_d = this.hmm.sensorModel().asMatrix(this.evidenceFromSmoothedStepToPresent.get(0));
            this.B = O_t_minus_d.inverse().times(transitionMatrix.inverse().times(this.B.times(transitionMatrix.times(O_t))));
        } else {
            this.B = this.B.times(transitionMatrix.times(O_t));
        }
        ++this.time;
        if (this.time > this.timelag) {
            Matrix one = this.hmm.prior().createUnitBelief().asMatrix();
            Matrix forwardMatrix = this.forwardMessage.asMatrix();
            RandomVariable result = this.hmm.prior().duplicate();
            Matrix backwardMessage = this.B.times(one);
            result.updateFrom(forwardMatrix.arrayTimes(backwardMessage));
            result.normalize();
            return result;
        }
        return null;
    }
}

