/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.HiddenMarkovModel;

public class HMMAgent {
    private HiddenMarkovModel hmm;
    private RandomVariable belief;

    public HMMAgent(HiddenMarkovModel hmm) {
        this.hmm = hmm;
        this.belief = hmm.prior().duplicate();
    }

    public RandomVariable belief() {
        return this.belief;
    }

    public void act(String action) {
        this.belief = this.hmm.predict(this.belief, action);
    }

    public void waitWithoutActing() {
        this.act("do_nothing");
    }

    public void perceive(String perception) {
        this.belief = this.hmm.perceptionUpdate(this.belief, perception);
    }
}

