/*
 * Decompiled with CFR 0.152.
 */
package aima.search.csp;

import aima.search.csp.Constraint;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Assignment {
    Hashtable<String, Object> variablesToValues = new Hashtable();
    List<String> variables;

    public Assignment() {
        this(new ArrayList<String>());
    }

    public Assignment(List<String> variables) {
        this.variables = variables;
    }

    public void setAssignment(String variable, Object value) {
        this.variablesToValues.put(variable, value);
    }

    public Object getAssignment(String variable) {
        return this.variablesToValues.get(variable);
    }

    public boolean isComplete() {
        return this.everyVariableIsAKeyAndHasAValue();
    }

    private boolean everyVariableIsAKeyAndHasAValue() {
        for (String variable : this.variables) {
            if (!this.variablesToValues.keySet().contains(variable)) {
                return false;
            }
            if (this.variablesToValues.get(variable) != null) continue;
            return false;
        }
        return true;
    }

    public void remove(String variable) {
        if (this.variablesToValues.keySet().contains(variable)) {
            this.variablesToValues.remove(variable);
        }
    }

    public String selectFirstUnassignedVariable() {
        for (String variable : this.variables) {
            if (this.variablesToValues.keySet().contains(variable)) continue;
            return variable;
        }
        return null;
    }

    public boolean hasAssignmentFor(String variable) {
        return this.variablesToValues.keySet().contains(variable);
    }

    public String toString() {
        return this.variablesToValues.toString();
    }

    public Assignment copy() {
        Assignment copy = new Assignment();
        for (int i = 0; i < this.variables.size(); ++i) {
            copy.variables.add(this.variables.get(i));
        }
        for (String key : this.variablesToValues.keySet()) {
            copy.variablesToValues.put(key, this.variablesToValues.get(key));
        }
        return copy;
    }

    public int getNumberOfConflictsFor(String conflictedVariable, Object value, Constraint constraint) {
        Assignment duplicate = this.copy();
        duplicate.setAssignment(conflictedVariable, value);
        return duplicate.getConflictedVariables(constraint).size();
    }

    public List<String> getConflictedVariables(Constraint constraint) {
        ArrayList<String> conflictedVariables = new ArrayList<String>();
        List<String> variables = this.getVariables();
        for (String variable : variables) {
            Object value;
            if (constraint.isSatisfiedWith(this, variable, value = this.getAssignment(variable))) continue;
            conflictedVariables.add(variable);
        }
        return conflictedVariables;
    }

    public Object getMinimumConflictingValueFor(String conflictedVariable, List domain, Constraint constraint) {
        int minConflict = Integer.MAX_VALUE;
        Object minConflictValue = null;
        for (int i = 0; i < domain.size(); ++i) {
            Object value = domain.get(i);
            if (this.getNumberOfConflictsFor(conflictedVariable, value, constraint) >= minConflict) continue;
            minConflict = this.getNumberOfConflictsFor(conflictedVariable, value, constraint);
            minConflictValue = value;
        }
        return minConflictValue;
    }

    public boolean satisfies(Constraint constraint) {
        if (this.isComplete()) {
            for (int j = 0; j < this.getVariables().size(); ++j) {
                Object value;
                String variable = this.getVariables().get(j);
                if (constraint.isSatisfiedWith(this, variable, value = this.getAssignment(variable))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String> getVariables() {
        return this.variables;
    }
}

