/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed.ga;

import aima.search.framework.GoalTest;
import aima.search.framework.Metrics;
import aima.search.informed.ga.FitnessFunction;
import aima.util.Util;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class GeneticAlgorithm {
    protected Metrics metrics = new Metrics();
    protected static final String POPULATION_SIZE = "populationSize";
    protected static final String ITERATIONS = "iterations";
    private final int individualLength;
    private final Character[] finiteAlphabet;
    private final double mutationProbability;
    private final Random random = new Random();

    public GeneticAlgorithm(int individualLength, Set<Character> finiteAlphabet, double mutationProbability) {
        this.individualLength = individualLength;
        this.finiteAlphabet = finiteAlphabet.toArray(new Character[finiteAlphabet.size()]);
        this.mutationProbability = mutationProbability;
        assert (this.mutationProbability >= 0.0 && this.mutationProbability <= 1.0);
    }

    public String geneticAlgorithm(Set<String> population, FitnessFunction fitnessFn, GoalTest goalTest) {
        String bestIndividual = null;
        this.validatePopulation(population);
        this.clearInstrumentation();
        this.setPopulationSize(population.size());
        int cnt = 0;
        do {
            bestIndividual = this.ga(population, fitnessFn);
            ++cnt;
        } while (!goalTest.isGoalState(bestIndividual));
        this.setIterations(cnt);
        return bestIndividual;
    }

    public String geneticAlgorithm(Set<String> population, FitnessFunction fitnessFn, int iterations) {
        String bestIndividual = null;
        this.validatePopulation(population);
        this.clearInstrumentation();
        this.setPopulationSize(population.size());
        for (int i = 0; i < iterations; ++i) {
            bestIndividual = this.ga(population, fitnessFn);
        }
        this.setIterations(iterations);
        return bestIndividual;
    }

    public void clearInstrumentation() {
        this.setPopulationSize(0);
        this.setIterations(0);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getPopulationSize() {
        return this.metrics.getInt(POPULATION_SIZE);
    }

    public void setPopulationSize(int size) {
        this.metrics.set(POPULATION_SIZE, size);
    }

    public int getIterations() {
        return this.metrics.getInt(ITERATIONS);
    }

    public void setIterations(int cnt) {
        this.metrics.set(ITERATIONS, cnt);
    }

    private void validatePopulation(Set<String> population) {
        assert (population.size() >= 1);
        for (String individual : population) {
            assert (individual.length() == this.individualLength);
        }
    }

    private String ga(Set<String> population, FitnessFunction fitnessFn) {
        HashSet<String> newPopulation = new HashSet<String>();
        for (int i = 0; i < population.size(); ++i) {
            String x = this.randomSelection(population, fitnessFn);
            String y = this.randomSelection(population, fitnessFn);
            String child = this.reproduce(x, y);
            if (this.random.nextDouble() <= this.mutationProbability) {
                child = this.mutate(child);
            }
            newPopulation.add(child);
        }
        population.clear();
        population.addAll(newPopulation);
        return this.retrieveBestIndividual(population, fitnessFn);
    }

    private String randomSelection(Set<String> population, FitnessFunction fitnessFn) {
        String selected = null;
        double[] fValues = new double[population.size()];
        String[] popArray = population.toArray(new String[population.size()]);
        for (int i = 0; i < popArray.length; ++i) {
            fValues[i] = fitnessFn.getValue(popArray[i]);
        }
        fValues = Util.normalize(fValues);
        double prob = this.random.nextDouble();
        double totalSoFar = 0.0;
        for (int i = 0; i < fValues.length; ++i) {
            if (!(prob <= (totalSoFar += fValues[i]))) continue;
            selected = popArray[i];
            break;
        }
        if (null == selected) {
            selected = popArray[popArray.length - 1];
        }
        return selected;
    }

    private String reproduce(String x, String y) {
        int c = this.randomOffset(this.individualLength);
        return x.substring(0, c) + y.substring(c);
    }

    private String mutate(String individual) {
        StringBuffer mutInd = new StringBuffer(individual);
        int posOffset = this.randomOffset(this.individualLength);
        int charOffset = this.randomOffset(this.finiteAlphabet.length);
        mutInd.setCharAt(posOffset, this.finiteAlphabet[charOffset].charValue());
        return mutInd.toString();
    }

    private String retrieveBestIndividual(Set<String> population, FitnessFunction fitnessFn) {
        String bestIndividual = null;
        double bestSoFarFValue = Double.MIN_VALUE;
        for (String individual : population) {
            double fValue = fitnessFn.getValue(individual);
            if (!(fValue > bestSoFarFValue)) continue;
            bestIndividual = individual;
            bestSoFarFValue = fValue;
        }
        return bestIndividual;
    }

    private int randomOffset(int length) {
        return this.random.nextInt(length);
    }
}

