/*
 * Decompiled with CFR 0.152.
 */
package aima.search.map;

import aima.basic.Percept;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SimpleProblemSolvingAgent;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.MapEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MapAgent
extends SimpleProblemSolvingAgent {
    private MapEnvironment mapEnvironment = null;
    private Search search = null;
    private String currentLocation = null;
    private String[] goalTests = null;
    private int goalTestPos = 0;
    private HeuristicFunction heuristicFunction = null;

    public MapAgent(MapEnvironment mapEnvironment, Search search) {
        this.mapEnvironment = mapEnvironment;
        this.search = search;
    }

    public MapAgent(MapEnvironment mapEnvironment, Search search, int maxGoalsToFormulate) {
        super(maxGoalsToFormulate);
        this.mapEnvironment = mapEnvironment;
        this.search = search;
    }

    public MapAgent(MapEnvironment mapEnvironment, Search search, String[] goalTests) {
        super(goalTests.length);
        this.mapEnvironment = mapEnvironment;
        this.search = search;
        this.goalTests = new String[goalTests.length];
        System.arraycopy(goalTests, 0, this.goalTests, 0, goalTests.length);
    }

    public HeuristicFunction getHeuristicFunction() {
        return this.heuristicFunction;
    }

    public void setHeuristicFunction(HeuristicFunction heuristicFunction) {
        this.heuristicFunction = heuristicFunction;
    }

    @Override
    protected Object updateState(Percept p) {
        this.currentLocation = (String)p.getAttribute("In");
        return this.currentLocation;
    }

    @Override
    protected Object formulateGoal() {
        String goal = null;
        if (null == this.goalTests) {
            goal = this.mapEnvironment.getMap().randomlyGenerateDestination();
        } else {
            goal = this.goalTests[this.goalTestPos];
            ++this.goalTestPos;
        }
        this.mapEnvironment.updateViews("CurrentLocation=In(" + this.currentLocation + "), Goal=In(" + goal + ")");
        return goal;
    }

    @Override
    protected Problem formulateProblem(Object goal) {
        if (null == this.getHeuristicFunction()) {
            return new BidirectionalMapProblem(this.mapEnvironment.getMap(), this.currentLocation, (String)goal);
        }
        return new BidirectionalMapProblem(this.mapEnvironment.getMap(), this.currentLocation, (String)goal, this.getHeuristicFunction());
    }

    @Override
    protected List<String> search(Problem problem) {
        ArrayList<String> actions2 = new ArrayList<String>();
        try {
            List sactions = this.search.search(problem);
            for (Object action : sactions) {
                actions2.add((String)action);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return actions2;
    }

    @Override
    protected void notifyViewOfMetrics() {
        Set keys = this.search.getMetrics().keySet();
        for (Object key : keys) {
            this.mapEnvironment.updateViews("METRIC[" + key + "]=" + this.search.getMetrics().get((String)key));
        }
    }
}

