/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nodestore;

import aima.datastructures.LIFOQueue;
import aima.search.framework.Node;
import aima.search.framework.NodeStore;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mcgraphresolver.aima_classes.uninformed.NodeStateUninformed;
import mcgraphresolver.utils.SharePreferencesHandler;

public class LIFONodeStore
implements NodeStore {
    LIFOQueue queue = new LIFOQueue();
    SharePreferencesHandler sharePreferencesHandler;

    @Override
    public void add(Node anItem) {
        this.queue.add(anItem);
        this.sharePreferencesHandler = new SharePreferencesHandler();
    }

    @Override
    public Node remove() {
        return (Node)this.queue.remove();
    }

    public void add(List nodes) {
        if (this.sharePreferencesHandler.isFringeOrderedByNodeLabelDesc()) {
            Collections.sort(nodes, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Node && o2 instanceof Node && ((Node)o1).getState() instanceof NodeStateUninformed && ((Node)o2).getState() instanceof NodeStateUninformed) {
                        String l1 = ((NodeStateUninformed)((Node)o1).getState()).getFxNodeGeneric().getBtnNode().getText();
                        String l2 = ((NodeStateUninformed)((Node)o2).getState()).getFxNodeGeneric().getBtnNode().getText();
                        return l2.compareTo(l1);
                    }
                    return 0;
                }
            });
        }
        this.queue.add(nodes);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

