/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nqueens;

import aima.basic.XYLocation;
import aima.search.framework.GoalTest;
import aima.search.informed.ga.FitnessFunction;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class NQueensFitnessFunction
implements FitnessFunction,
GoalTest {
    private final NQueensGoalTest goalTest = new NQueensGoalTest();

    @Override
    public Double getValue(String individual) {
        double fitness = 0.0;
        NQueensBoard board = this.getBoardForIndividual(individual);
        int boardSize = board.getSize();
        List<XYLocation> qPositions = board.getQueenPositions();
        for (int fromX = 0; fromX < boardSize - 1; ++fromX) {
            for (int toX = fromX + 1; toX < boardSize; ++toX) {
                int fromY = qPositions.get(fromX).getYCoOrdinate();
                boolean nonAttackingPair = true;
                int toY = fromY;
                if (board.queenExistsAt(new XYLocation(toX, toY))) {
                    nonAttackingPair = false;
                }
                if ((toY = fromY - (toX - fromX)) >= 0 && board.queenExistsAt(new XYLocation(toX, toY))) {
                    nonAttackingPair = false;
                }
                if ((toY = fromY + (toX - fromX)) < boardSize && board.queenExistsAt(new XYLocation(toX, toY))) {
                    nonAttackingPair = false;
                }
                if (!nonAttackingPair) continue;
                fitness += 1.0;
            }
        }
        return fitness;
    }

    @Override
    public boolean isGoalState(Object state) {
        return this.goalTest.isGoalState(this.getBoardForIndividual((String)state));
    }

    public NQueensBoard getBoardForIndividual(String individual) {
        int boardSize = individual.length();
        NQueensBoard board = new NQueensBoard(boardSize);
        for (int i = 0; i < boardSize; ++i) {
            int pos = Character.digit(individual.charAt(i), individual.length());
            board.addQueenAt(new XYLocation(i, pos));
        }
        return board;
    }

    public String generateRandomIndividual(int boardSize) {
        StringBuffer ind = new StringBuffer();
        assert (boardSize >= 2 && boardSize <= 36);
        for (int i = 0; i < boardSize; ++i) {
            ind.append(Character.forDigit(new Random().nextInt(boardSize), boardSize));
        }
        return ind.toString();
    }

    public Set<Character> getFiniteAlphabetForBoardOfSize(int size) {
        HashSet<Character> fab = new HashSet<Character>();
        assert (size >= 2 && size <= 36);
        for (int i = 0; i < size; ++i) {
            fab.add(Character.valueOf(Character.forDigit(i, size)));
        }
        return fab;
    }
}

