/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probabilitytest;

import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import java.util.List;
import junit.framework.TestCase;

public class BayesNetTest
extends TestCase {
    BayesNet net;

    @Override
    public void setUp() {
        this.net = this.createBurglaryNetwork();
    }

    public void testVariablesAreCorrectlyObtainedFromBayesNetwork() {
        List<String> variables = this.net.getVariables();
        BayesNetTest.assertEquals(5, variables.size());
        BayesNetTest.assertEquals("Burglary", variables.get(0));
        BayesNetTest.assertEquals("EarthQuake", variables.get(1));
        BayesNetTest.assertEquals("Alarm", variables.get(2));
        BayesNetTest.assertEquals("JohnCalls", variables.get(3));
        BayesNetTest.assertEquals("MaryCalls", variables.get(4));
    }

    private BayesNet createBurglaryNetwork() {
        BayesNetNode burglary = new BayesNetNode("Burglary");
        BayesNetNode earthquake = new BayesNetNode("EarthQuake");
        BayesNetNode alarm = new BayesNetNode("Alarm");
        BayesNetNode johnCalls = new BayesNetNode("JohnCalls");
        BayesNetNode maryCalls = new BayesNetNode("MaryCalls");
        alarm.influencedBy(burglary, earthquake);
        johnCalls.influencedBy(alarm);
        maryCalls.influencedBy(alarm);
        burglary.setProbability(true, 0.001);
        earthquake.setProbability(true, 0.002);
        alarm.setProbability(true, true, 0.95);
        alarm.setProbability(true, false, 0.94);
        alarm.setProbability(false, true, 0.29);
        alarm.setProbability(false, false, 0.001);
        johnCalls.setProbability(true, 0.9);
        johnCalls.setProbability(false, 0.05);
        maryCalls.setProbability(true, 0.7);
        maryCalls.setProbability(false, 0.01);
        BayesNet net = new BayesNet(burglary, earthquake);
        return net;
    }
}

