/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.framework.Successor;
import aima.search.map.ExtendableMap;
import aima.search.map.MapSuccessorFunction;
import java.util.ArrayList;
import junit.framework.TestCase;

public class MapSuccessorFunctionTest
extends TestCase {
    MapSuccessorFunction msf;

    @Override
    public void setUp() {
        ExtendableMap aMap = new ExtendableMap();
        aMap.addBidirectionalLink("A", "B", 5.0);
        aMap.addBidirectionalLink("A", "C", 6.0);
        aMap.addBidirectionalLink("B", "C", 4.0);
        aMap.addBidirectionalLink("C", "D", 7.0);
        aMap.addUnidirectionalLink("B", "E", 14.0);
        this.msf = new MapSuccessorFunction(aMap);
    }

    public void testSuccessors() {
        Successor s;
        ArrayList<String> locations = new ArrayList<String>();
        locations.clear();
        locations.add("B");
        locations.add("C");
        for (Object o : this.msf.getSuccessors("A")) {
            s = (Successor)o;
            MapSuccessorFunctionTest.assertTrue(locations.contains(s.getAction()) && locations.contains(s.getState()));
        }
        locations.clear();
        locations.add("A");
        locations.add("C");
        locations.add("E");
        for (Object o : this.msf.getSuccessors("B")) {
            s = (Successor)o;
            MapSuccessorFunctionTest.assertTrue(locations.contains(s.getAction()) && locations.contains(s.getState()));
        }
        locations.clear();
        locations.add("A");
        locations.add("B");
        locations.add("D");
        for (Object o : this.msf.getSuccessors("C")) {
            s = (Successor)o;
            MapSuccessorFunctionTest.assertTrue(locations.contains(s.getAction()) && locations.contains(s.getState()));
        }
        locations.clear();
        locations.add("C");
        for (Object o : this.msf.getSuccessors("D")) {
            s = (Successor)o;
            MapSuccessorFunctionTest.assertTrue(locations.contains(s.getAction()) && locations.contains(s.getState()));
        }
        locations.clear();
        MapSuccessorFunctionTest.assertTrue(0 == this.msf.getSuccessors("E").size());
    }
}

