/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.SimpleReflexVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class SimpleReflexVaccumAgentTest
extends TestCase {
    private SimpleReflexVaccumAgent agent;
    private StringBuffer envChanges;

    @Override
    public void setUp() {
        this.agent = new SimpleReflexVaccumAgent();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                SimpleReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        SimpleReflexVaccumAgentTest.assertEquals("RightLeftRightLeftRightLeftRightLeft", this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                SimpleReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        SimpleReflexVaccumAgentTest.assertEquals("RightSuckLeftRightLeftRightLeftRight", this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                SimpleReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        SimpleReflexVaccumAgentTest.assertEquals("SuckRightLeftRightLeftRightLeftRight", this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                SimpleReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        SimpleReflexVaccumAgentTest.assertEquals("SuckRightSuckLeftRightLeftRightLeft", this.envChanges.toString());
    }
}

