/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.List;

public class MixedRadixNumber
extends Number {
    private static final long serialVersionUID = 1L;
    private long value = 0L;
    private long maxValue = 0L;
    private int[] radixs = null;
    private int[] currentNumeralValue = null;
    private boolean recalculate = true;

    public MixedRadixNumber(long value, int[] radixs) {
        this.value = value;
        this.radixs = new int[radixs.length];
        System.arraycopy(radixs, 0, this.radixs, 0, radixs.length);
        this.calculateMaxValue();
    }

    public MixedRadixNumber(long value, List<Integer> radixs) {
        this.value = value;
        this.radixs = new int[radixs.size()];
        for (int i = 0; i < radixs.size(); ++i) {
            this.radixs[i] = radixs.get(i);
        }
        this.calculateMaxValue();
    }

    public long getMaxAllowedValue() {
        return this.maxValue;
    }

    public boolean increment() {
        if (this.value < this.maxValue) {
            ++this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public boolean decrement() {
        if (this.value > 0L) {
            --this.value;
            this.recalculate = true;
            return true;
        }
        return false;
    }

    public int getCurrentNumeralValue(int atPosition) {
        if (atPosition >= 0 && atPosition < this.radixs.length) {
            if (this.recalculate) {
                long quotient = this.value;
                for (int i = 0; i < this.radixs.length; ++i) {
                    if (0L != quotient) {
                        this.currentNumeralValue[i] = (int)quotient % this.radixs[i];
                        quotient /= (long)this.radixs[i];
                        continue;
                    }
                    this.currentNumeralValue[i] = 0;
                }
                this.recalculate = false;
            }
            return this.currentNumeralValue[atPosition];
        }
        throw new IllegalArgumentException("Argument atPosition must be >=0 and < " + this.radixs.length);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.radixs.length; ++i) {
            sb.append("[");
            sb.append(this.getCurrentNumeralValue(i));
            sb.append("]");
        }
        return sb.toString();
    }

    private void calculateMaxValue() {
        int i;
        if (0 == this.radixs.length) {
            throw new IllegalArgumentException("At least 1 radix must be defined.");
        }
        for (i = 0; i < this.radixs.length; ++i) {
            if (this.radixs[i] >= 2) continue;
            throw new IllegalArgumentException("Invalid radix, must be >= 2");
        }
        this.maxValue = this.radixs[0];
        for (i = 1; i < this.radixs.length; ++i) {
            this.maxValue *= (long)this.radixs[i];
        }
        --this.maxValue;
        if (this.value > this.maxValue) {
            throw new IllegalArgumentException("The value [" + this.value + "] cannot be represented with the radixs provided, max value is " + this.maxValue);
        }
        this.currentNumeralValue = new int[this.radixs.length];
    }
}

