/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXGraph;
import fxgraph.FXNode;
import fxgraph.OnAddLink;
import fxgraph.OnRemoveNode;
import java.util.ResourceBundle;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class FXNodeGeneric
extends FXNode
implements Comparable {
    private final ContextMenu contextMenu;
    private SharePreferencesHandler sharePreferencesHandler = new SharePreferencesHandler();
    private static Color GENERIC_NODE_COLOR = Color.valueOf((String)"#00b8d4");
    private static Color SOURCE_NODE_COLOR = Color.valueOf((String)"#d50000");
    private static Color DESTINATION_NODE_COLOR = Color.valueOf((String)"#00c853");
    private VBox vBox;
    private FXGraph graphOwner;
    private Button btnNode;
    private Label lblEstimate;
    private nodeType type = nodeType.GENERIC_NODE;
    private OnRemoveNode onRemoveNodeListener = null;
    private OnAddLink onAddLinkToNodeListener = null;

    public void setOnRemoveNodeListener(OnRemoveNode onRemoveNodeListener) {
        this.onRemoveNodeListener = onRemoveNodeListener;
        MenuItem delete = new MenuItem(onRemoveNodeListener.getTextDeleteNode());
        delete.setOnAction(event -> onRemoveNodeListener.onRemove(true));
        this.contextMenu.getItems().add((Object)delete);
    }

    public void setOnAddLinkToNodeListener(OnAddLink onAddLinkToNodeListener) {
        this.onAddLinkToNodeListener = onAddLinkToNodeListener;
        MenuItem addLink = new MenuItem(onAddLinkToNodeListener.getTextNodeToLink());
        addLink.setOnAction(event -> onAddLinkToNodeListener.onAddLink());
        this.contextMenu.getItems().add((Object)addLink);
    }

    public OnRemoveNode getOnRemoveNodeListener() {
        return this.onRemoveNodeListener;
    }

    @Override
    public void onSelect() {
        if (this.type == nodeType.SOURCE_NODE) {
            this.getBtnNode().setStyle("-fx-background-color: " + Utils.toRGBCode(Utils.darkerColor(SOURCE_NODE_COLOR, 0.5)) + ";");
        } else if (this.type == nodeType.DESTINATION_NODE) {
            this.getBtnNode().setStyle("-fx-background-color: " + Utils.toRGBCode(Utils.darkerColor(DESTINATION_NODE_COLOR, 0.5)) + ";");
        } else {
            this.getBtnNode().setStyle("-fx-background-color: " + Utils.toRGBCode(Utils.darkerColor(GENERIC_NODE_COLOR, 0.5)) + ";");
        }
    }

    @Override
    public void onDeselect() {
        this.setType(this.getType());
    }

    public FXNodeGeneric(String label, double estimate, FXGraph graphOwner) {
        this.vBox = this.createVBox(label, estimate);
        this.graphOwner = graphOwner;
        this.setNode((Node)this.vBox);
        this.contextMenu = new ContextMenu();
        SOURCE_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000"));
        DESTINATION_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853"));
        GENERIC_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4"));
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public VBox getVBox() {
        return this.vBox;
    }

    public void setVBox(VBox vBox) {
        this.vBox = vBox;
    }

    public Button getBtnNode() {
        return this.btnNode;
    }

    public void setBtnNode(Button btnNode) {
        this.btnNode = btnNode;
    }

    public Label getLblEstimate() {
        return this.lblEstimate;
    }

    public void setLblEstimate(Label lblEstimate) {
        this.lblEstimate = lblEstimate;
    }

    public void setTextLabel(String newTextLabel) {
        this.btnNode.setText(newTextLabel);
    }

    public void setEstimate(double newEstimate) {
        this.lblEstimate.setText(String.valueOf(newEstimate));
    }

    public nodeType getType() {
        return this.type;
    }

    public void setType(nodeType type) {
        this.type = type;
        if (type == nodeType.SOURCE_NODE) {
            this.setBackgroundColor(SOURCE_NODE_COLOR);
        } else if (type == nodeType.DESTINATION_NODE) {
            this.setBackgroundColor(DESTINATION_NODE_COLOR);
        } else {
            this.setBackgroundColor(GENERIC_NODE_COLOR);
        }
    }

    public void setBackgroundColor(Color color) {
        if (this.type == nodeType.SOURCE_NODE) {
            SOURCE_NODE_COLOR = color;
        } else if (this.type == nodeType.DESTINATION_NODE) {
            DESTINATION_NODE_COLOR = color;
        } else {
            GENERIC_NODE_COLOR = color;
        }
        this.btnNode.setStyle("-fx-background-color: " + Utils.toRGBCode(color) + ";");
    }

    public boolean equals(Object other) {
        if (!(other instanceof FXNodeGeneric)) {
            return false;
        }
        FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)other;
        return this.btnNode.getText().equals(fxNodeGeneric.getBtnNode().getText());
    }

    private VBox createVBox(String label, double estimate) {
        VBox vBox = new VBox();
        this.lblEstimate = new Label("" + estimate);
        this.lblEstimate.setStyle("-fx-font-size: 15px; -fx-border-color: black; -fx-padding: 3px;");
        this.btnNode = new Button(label);
        this.btnNode.getStyleClass().add((Object)"custom-jfx-button-fab-node");
        this.btnNode.setStyle("-fx-background-color: #00b8d4;");
        this.lblEstimate.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK))));
        this.btnNode.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE))));
        this.btnNode.setMouseTransparent(true);
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(5.0);
        vBox.setPadding(new Insets(2.0));
        vBox.getChildren().add((Object)this.lblEstimate);
        vBox.getChildren().add((Object)this.btnNode);
        vBox.requestFocus();
        return vBox;
    }

    public static String getNodeTypeString(nodeType nodeType2, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            switch (nodeType2) {
                case SOURCE_NODE: {
                    return resourceBundle.getString("text_source_node");
                }
                case GENERIC_NODE: {
                    return resourceBundle.getString("text_generic_node");
                }
                case DESTINATION_NODE: {
                    return resourceBundle.getString("text_destination_node");
                }
            }
            return resourceBundle.getString("text_generic_node");
        }
        return "";
    }

    public int compareTo(Object object) {
        if (!(object instanceof FXNodeGeneric)) {
            return 0;
        }
        FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)object;
        return this.btnNode.getText().compareToIgnoreCase(fxNodeGeneric.getBtnNode().getText());
    }

    public String toString() {
        return "FXNodeGeneric{vBox=" + this.vBox + ", btnNode=" + this.btnNode + ", lblEstimate=" + this.lblEstimate + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum nodeType {
        GENERIC_NODE,
        SOURCE_NODE,
        DESTINATION_NODE;

    }
}

